/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.toro;

import de.justsoftware.admin.connector.toro.ScimFieldMapping;
import de.justsoftware.admin.graphql.generated.types.ApiToken;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J4\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/admin/connector/toro/ToroConnector;", "", "toroInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "deleteAppHomeScreenPositionsOfUsers", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "getScimToken", "Lde/justsoftware/admin/graphql/generated/types/ApiToken;", "getFieldMapping", "Lde/justsoftware/admin/connector/toro/ScimFieldMapping;", "createFieldMapping", "mapping", "", "", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "generateScimToken", "deleteScimToken", "", "admin-service"})
public class ToroConnector {
    @NotNull
    private final RestClient restClient;

    public ToroConnector(@Value(value="${just.toro.internal.host.url}") @NotNull String toroInternalUrl, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        RestClient restClient = restClientBuilder.baseUrl(toroInternalUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    public void deleteAppHomeScreenPositionsOfUsers(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.restClient.delete().uri("/home-screen-app-positions/" + tenantId, new Object[0]);
    }

    @Nullable
    public ApiToken getScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (ApiToken)this.restClient.get().uri(arg_0 -> ToroConnector.getScimToken$lambda$0(tenantId, arg_0)).retrieve().toEntity(ApiToken.class).getBody();
    }

    @Nullable
    public ScimFieldMapping getFieldMapping(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (ScimFieldMapping)this.restClient.get().uri(arg_0 -> ToroConnector.getFieldMapping$lambda$1(tenantId, arg_0)).retrieve().toEntity(ScimFieldMapping.class).getBody();
    }

    @Nullable
    public ScimFieldMapping createFieldMapping(@NotNull Map<String, ? extends Set<String>> mapping, @NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return (ScimFieldMapping)((RestClient.RequestBodySpec)this.restClient.post().uri(arg_0 -> ToroConnector.createFieldMapping$lambda$2(tenantId, profileId, arg_0))).contentType(MediaType.APPLICATION_JSON).body(mapping).retrieve().toEntity(ScimFieldMapping.class).getBody();
    }

    @NotNull
    public ApiToken generateScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Object object = ((RestClient.RequestBodySpec)this.restClient.post().uri(arg_0 -> ToroConnector.generateScimToken$lambda$3(tenantId, arg_0))).retrieve().toEntity(ApiToken.class).getBody();
        Intrinsics.checkNotNull((Object)object);
        return (ApiToken)object;
    }

    public boolean deleteScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.restClient.delete().uri(arg_0 -> ToroConnector.deleteScimToken$lambda$4(tenantId, arg_0)).retrieve().toEntity(Void.class);
        return true;
    }

    private static final URI getScimToken$lambda$0(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI getFieldMapping$lambda$1(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/profile/scim/fieldmapping").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI createFieldMapping$lambda$2(TenantId $tenantId, ProfileId $profileId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        UriBuilder uriBuilder = it.path("/profile/scim/fieldmapping").queryParam("tenantId", objectArray);
        objectArray = new Object[]{$profileId.toTypedString()};
        return uriBuilder.queryParam("createdBy", objectArray).build(new Object[0]);
    }

    private static final URI generateScimToken$lambda$3(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI deleteScimToken$lambda$4(TenantId $tenantId, UriBuilder it) {
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }
}

