/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;

public class RequestSend
extends NetworkSend {
    private final RequestHeader header;
    private final Struct body;

    public RequestSend(String destination, RequestHeader header, Struct body2) {
        super(destination, RequestSend.serialize(header, body2));
        this.header = header;
        this.body = body2;
    }

    private static ByteBuffer serialize(RequestHeader header, Struct body2) {
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf() + body2.sizeOf());
        header.writeTo(buffer);
        body2.writeTo(buffer);
        buffer.rewind();
        return buffer;
    }

    public RequestHeader header() {
        return this.header;
    }

    public Struct body() {
        return this.body;
    }

    public String toString() {
        return "RequestSend(header=" + this.header.toString() + ", body=" + this.body.toString() + ")";
    }
}

