/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import de.justsoftware.authentication.configuration.MetadataConfiguration;
import de.justsoftware.authentication.saml.ModernHTTPMetadataProvider;
import de.justsoftware.authentication.service.AuthenticationMetricsService;
import de.justsoftware.authentication.service.JustHealthIndicator;
import de.justsoftware.authentication.service.SecretManager;
import de.justsoftware.authentication.utils.UrlUtils;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.metadata.MetadataMemoryProvider;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class MetadataUpdateService
implements InitializingBean,
DisposableBean,
JustHealthIndicator {
    @VisibleForTesting
    static final String MS_IDP_DEFAULT_METADATA_URL_SUFFIX = "/FederationMetadata/2007-06/FederationMetadata.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataUpdateService.class);
    private final MetadataConfiguration _configuration;
    private final SecretManager _secretManager;
    private final MetadataManager _metadataManager;
    private final MetadataGenerator _metadataGenerator;
    private final ParserPool _parserPool;
    private final CloseableHttpClient _httpClient;
    private final Timer _timer;
    private final AuthenticationMetricsService _metrics;
    private final AtomicBoolean _serviceOk = new AtomicBoolean(false);
    private final AtomicLong _lastRefreshTime = new AtomicLong(0L);

    @Autowired
    public MetadataUpdateService(MetadataGenerator metadataGenerator, SecretManager secretManager, MetadataConfiguration configuration, MetadataManager metadataManager, ParserPool parserPool, AuthenticationMetricsService metrics) {
        this._configuration = configuration;
        this._secretManager = secretManager;
        this._metadataManager = metadataManager;
        this._metadataGenerator = metadataGenerator;
        this._parserPool = parserPool;
        this._httpClient = this.buildHttpClient();
        this._timer = new Timer("metadataRefreshTimer", true);
        this._metrics = metrics;
    }

    @Nonnull
    private CloseableHttpClient buildHttpClient() {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(15000).setConnectionRequestTimeout(15000).build();
        return HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).useSystemProperties().build();
    }

    public void afterPropertiesSet() {
        this._configuration.addChangeListener((arg_0, arg_1, arg_2) -> this.refreshMetadataManager(arg_0, arg_1, arg_2));
    }

    public void destroy() {
        this._timer.cancel();
        this._timer.purge();
    }

    public void doHealthCheck(Health.Builder builder) {
        builder.up().withDetail("metadata.ok", (Object)this._serviceOk.get()).withDetail("metadata.lastRefresh", (Object)this._lastRefreshTime.get());
        if (!this._serviceOk.get() || this._lastRefreshTime.get() == 0L) {
            builder.down();
        }
    }

    public boolean refreshMetadataManager() {
        try {
            this.refreshMetadataManager(this._configuration.getSystemDomainPrefix(), this._configuration.getPrivateSslKey(), this._configuration.getIdpServer());
            return true;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    private void refreshMetadataManager(String systemDomainPrefix, String privateKey, String idpServer) {
        try {
            LOGGER.debug("start refreshing metadata manager");
            this._lastRefreshTime.set(System.currentTimeMillis());
            Verify.verifyNotNull((Object)Strings.emptyToNull((String)systemDomainPrefix), (String)"no system domain prefix configured... ignoring metadata config changes", (Object[])new Object[0]);
            Verify.verifyNotNull((Object)Strings.emptyToNull((String)privateKey), (String)"no private ssl key configured... ignoring metadata config changes", (Object[])new Object[0]);
            Verify.verifyNotNull((Object)Strings.emptyToNull((String)idpServer), (String)"no idp server configured... ignoring metadata config changes", (Object[])new Object[0]);
            String entityId = UrlUtils.getHost((String)systemDomainPrefix);
            String spUrl = UrlUtils.getSpUrl((String)systemDomainPrefix);
            String idpUrl = MetadataUpdateService.getIdpUrl((String)idpServer);
            this._secretManager.setServiceProvider(entityId, spUrl, privateKey);
            ModernHTTPMetadataProvider idp = new ModernHTTPMetadataProvider(this._timer, this._httpClient, idpUrl);
            idp.setParserPool(this._parserPool);
            this._secretManager.setIdentityProvider(idpUrl);
            ExtendedMetadataDelegate idpDelegate = new ExtendedMetadataDelegate((MetadataProvider)idp);
            idpDelegate.setMetadataTrustCheck(false);
            this._metadataGenerator.setEntityId(entityId);
            this._metadataGenerator.setEntityBaseURL(UrlUtils.joinUrl((String)spUrl, (String)"/authentication"));
            ExtendedMetadataDelegate sp = new ExtendedMetadataDelegate((MetadataProvider)new MetadataMemoryProvider(this._metadataGenerator.generateMetadata()), this._metadataGenerator.generateExtendedMetadata());
            this._metadataManager.getAvailableProviders().forEach(ExtendedMetadataDelegate::destroy);
            this._metadataManager.setProviders((List)ImmutableList.of((Object)sp, (Object)idpDelegate));
            this._metadataManager.setHostedSPName(entityId);
            this._metadataManager.refreshMetadata();
            LOGGER.info("successfully refreshed metadata");
            this._serviceOk.set(true);
            this._metrics.refreshedMetadata();
        }
        catch (IOException | RuntimeException | MetadataProviderException e) {
            LOGGER.error("error refreshing metadata", e);
            this._serviceOk.set(false);
            throw new SAMLRuntimeException((Exception)e);
        }
    }

    @Nonnull
    @VisibleForTesting
    static String getIdpUrl(String idpServer) {
        boolean pathIsEmpty;
        URI uri = URI.create(idpServer);
        boolean bl = pathIsEmpty = uri.getPath().isEmpty() || uri.getPath().equals("/");
        if (uri.getPath().equals(idpServer) || pathIsEmpty) {
            return UrlUtils.joinUrl((String)UrlUtils.getHttpsUrl((String)idpServer), (String)"/FederationMetadata/2007-06/FederationMetadata.xml");
        }
        return idpServer;
    }
}

