/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.service;

import de.justsoftware.authentication.model.kafka.KafkaPerson;
import de.justsoftware.authentication.model.kafka.KafkaPersonExternalId;
import de.justsoftware.authentication.service.JustHealthIndicator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.streams.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class KafkaPersonService
implements JustHealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersonService.class);
    private final Map<String, KafkaPerson> _personsByPersonId = new ConcurrentHashMap();
    private final Map<String, KafkaPerson> _personsByEmail = new ConcurrentHashMap();
    private final Map<String, String> _personIdsByExternalId = new ConcurrentHashMap();
    private final Map<String, String> _externalIdsByPersonId = new ConcurrentHashMap();
    private final boolean _useEmailForUserLookup;

    @Autowired
    public KafkaPersonService(@Value(value="${sso.useEmailForUserLookup}") boolean useEmailForUserLookup) {
        this._useEmailForUserLookup = useEmailForUserLookup;
    }

    public void doHealthCheck(Health.Builder builder) {
        builder.up().withDetail("kafka.persons", (Object)this._personsByPersonId.size()).withDetail("kafka.externalIds", (Object)this._personIdsByExternalId.size());
        if (this._personsByPersonId.isEmpty() || !this._useEmailForUserLookup && this._personIdsByExternalId.isEmpty()) {
            builder.down();
        }
    }

    @CheckForNull
    private String emailNormalized(@Nullable KafkaPerson person) {
        String email = person != null ? person.getEmail() : null;
        return email != null ? this.normalizeEmail(email) : null;
    }

    @Nonnull
    private String normalizeEmail(String email) {
        return email.toLowerCase();
    }

    private void removeNullPerson(String personId) {
        KafkaPerson person = (KafkaPerson)this._personsByPersonId.remove(personId);
        if (person == null || !this._useEmailForUserLookup) {
            return;
        }
        String email = this.emailNormalized(person);
        if (email != null) {
            this._personsByEmail.remove(email);
        }
    }

    private void removedDeletedExternalId(String personId) {
        String externalId = (String)this._externalIdsByPersonId.remove(personId);
        if (externalId != null) {
            this._personIdsByExternalId.remove(externalId);
        }
    }

    @CheckForNull
    public KafkaPerson getKafkaPersonByExternalId(String externalId) {
        String personId = (String)this._personIdsByExternalId.get(externalId);
        return personId != null ? (KafkaPerson)this._personsByPersonId.get(personId) : null;
    }

    @CheckForNull
    public KafkaPerson getKafkaPersonByEmail(String email) {
        return (KafkaPerson)this._personsByEmail.get(this.normalizeEmail(email));
    }

    @Nonnull
    public Processor<String, KafkaPerson> personProcessor() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    public Processor<String, KafkaPersonExternalId> externalIdProcessor() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

