/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import de.justsoftware.people.business.event.InternalPublishAllUsergroupsEvent;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.config.ConfigService;
import de.justsoftware.people.controller.InternalPeopleController;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import io.swagger.v3.oas.annotations.Hidden;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Hidden
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u000f\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0010\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0011\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\fH\u0017J\b\u0010\u001b\u001a\u00020\fH\u0017J\b\u0010\u001c\u001a\u00020\fH\u0017J\b\u0010\u001d\u001a\u00020\u0019H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/people/controller/InternalPeopleController;", "", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "searchService", "Lde/justsoftware/people/business/search/SearchService;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "configService", "Lde/justsoftware/people/config/ConfigService;", "(Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/business/search/SearchService;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/people/config/ConfigService;)V", "disableAbsence", "", "tenantId", "Lde/justsoftware/people/model/TenantId;", "disableBirthdayList", "enableAbsence", "enableBirthdayList", "getAbsenceConfig", "Lde/justsoftware/people/controller/InternalPeopleController$AbsenceConfig;", "getAllTenantUsersGroup", "Lde/justsoftware/people/model/UserGroupId;", "getBirthdayListConfig", "Lde/justsoftware/people/controller/InternalPeopleController$BirthdayListConfig;", "getUserGroupMembershipChecksum", "", "publishUserGroups", "reindexUserGroups", "status", "version", "AbsenceConfig", "BirthdayListConfig", "people-api"})
public class InternalPeopleController {
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final SearchService searchService;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final ConfigService configService;

    public InternalPeopleController(@NotNull UserGroupService userGroupService, @NotNull SearchService searchService, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.userGroupService = userGroupService;
        this.searchService = searchService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.configService = configService;
    }

    @PostMapping(value={"publish/groups"})
    public void publishUserGroups() {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new InternalPublishAllUsergroupsEvent((Object)this));
    }

    @PostMapping(value={"reindex/groups"})
    public void reindexUserGroups() {
        this.searchService.reindexAllGroups();
    }

    @PostMapping(value={"status"})
    public void status() {
    }

    @GetMapping(value={"version"}, produces={"text/plain"})
    @NotNull
    public String version() {
        return "24.9.5-4181";
    }

    @GetMapping(value={"/{tenantId}/allUsersGroup"})
    @NotNull
    public UserGroupId getAllTenantUsersGroup(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.userGroupService.createOrGetAllTenantUsersGroup(tenantId);
    }

    @GetMapping(value={"/userGroupMembershipChecksum"}, produces={"text/plain"})
    @NotNull
    public String getUserGroupMembershipChecksum() {
        return this.userGroupService.getUserGroupMembershipChecksum();
    }

    @GetMapping(value={"/{tenantId}/birthdayList"})
    @NotNull
    public BirthdayListConfig getBirthdayListConfig(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return new BirthdayListConfig(this.configService.isBirthdayListEnabled(tenantId));
    }

    @PostMapping(value={"/{tenantId}/birthdayList/enable"})
    public void enableBirthdayList(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.configService.setBirthdayListEnabled(tenantId, true);
    }

    @PostMapping(value={"/{tenantId}/birthdayList/disable"})
    public void disableBirthdayList(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.configService.setBirthdayListEnabled(tenantId, false);
    }

    @GetMapping(value={"/{tenantId}/absence"})
    @NotNull
    public AbsenceConfig getAbsenceConfig(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return new AbsenceConfig(this.configService.isAbsenceEnabled(tenantId));
    }

    @PostMapping(value={"/{tenantId}/absence/enable"})
    public void enableAbsence(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.configService.setAbsenceEnabled(tenantId, true);
    }

    @PostMapping(value={"/{tenantId}/absence/disable"})
    public void disableAbsence(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.configService.setAbsenceEnabled(tenantId, false);
    }
}

