/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.ConfigRepository;
import de.justsoftware.people.persistence.model.DbConfig;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/people/config/ConfigService;", "", "configRepository", "Lde/justsoftware/people/persistence/ConfigRepository;", "(Lde/justsoftware/people/persistence/ConfigRepository;)V", "getConfig", "Lde/justsoftware/people/persistence/model/DbConfig;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "isAbsenceEnabled", "", "isBirthdayListEnabled", "setAbsenceEnabled", "", "enabled", "setBirthdayListEnabled", "people-api"})
@SourceDebugExtension(value={"SMAP\nConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigService.kt\nde/justsoftware/people/config/ConfigService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public class ConfigService {
    @NotNull
    private final ConfigRepository configRepository;

    public ConfigService(@NotNull ConfigRepository configRepository) {
        Intrinsics.checkNotNullParameter((Object)configRepository, (String)"configRepository");
        this.configRepository = configRepository;
    }

    private DbConfig getConfig(TenantId tenantId) {
        DbConfig dbConfig = this.configRepository.findById(tenantId.getId()).orElse(new DbConfig((UUID)tenantId.getId(), false, false));
        Intrinsics.checkNotNullExpressionValue((Object)dbConfig, (String)"orElse(...)");
        return dbConfig;
    }

    public boolean isBirthdayListEnabled(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.getConfig(tenantId).isBirthdayListEnabled();
    }

    public boolean isAbsenceEnabled(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.getConfig(tenantId).isAbsenceEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public void setBirthdayListEnabled(@NotNull TenantId tenantId, boolean enabled) {
        void $this$setBirthdayListEnabled_u24lambda_u240;
        DbConfig dbConfig;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbConfig dbConfig2 = dbConfig = this.getConfig(tenantId);
        ConfigRepository configRepository = this.configRepository;
        boolean bl = false;
        $this$setBirthdayListEnabled_u24lambda_u240.setBirthdayListEnabled(enabled);
        configRepository.save((Object)dbConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void setAbsenceEnabled(@NotNull TenantId tenantId, boolean enabled) {
        void $this$setAbsenceEnabled_u24lambda_u241;
        DbConfig dbConfig;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbConfig dbConfig2 = dbConfig = this.getConfig(tenantId);
        ConfigRepository configRepository = this.configRepository;
        boolean bl = false;
        $this$setAbsenceEnabled_u24lambda_u241.setAbsenceEnabled(enabled);
        configRepository.save((Object)dbConfig);
    }
}

