/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import de.justsoftware.people.application.model.AbsenceInformation;
import de.justsoftware.people.business.event.ProfilesCreatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.KafkaProfileDto;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.model.DynamicProfileFields;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.AbsenceRepository;
import de.justsoftware.people.persistence.BirthdayReminderRepository;
import de.justsoftware.people.persistence.ProfileAttributeRepository;
import de.justsoftware.people.persistence.ProfileRepository;
import de.justsoftware.people.persistence.model.DbAbsence;
import de.justsoftware.people.persistence.model.DbBirthdayReminder;
import de.justsoftware.people.persistence.model.DbBirthdayReminderId;
import de.justsoftware.people.persistence.model.DbProfile;
import de.justsoftware.people.persistence.model.DbProfileAttribute;
import de.justsoftware.people.persistence.transaction.TransactionSupport;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 92\u00020\u0001:\u00019B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 2\u0006\u0010\"\u001a\u00020#H\u0012J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140%H\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J#\u0010-\u001a\u00020\u00122\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u0001000/H\u0011\u00a2\u0006\u0002\b1J!\u00102\u001a\u00020\u00122\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002030/H\u0011\u00a2\u0006\u0002\b4J\u0018\u00105\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J$\u00106\u001a\u00020\u00122\u001a\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0004\u0012\u000208\u0018\u00010+0\u001aH\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lde/justsoftware/people/business/profile/ProfileService;", "", "profileRepository", "Lde/justsoftware/people/persistence/ProfileRepository;", "profileAttributeRepository", "Lde/justsoftware/people/persistence/ProfileAttributeRepository;", "birthdayReminderRepository", "Lde/justsoftware/people/persistence/BirthdayReminderRepository;", "absenceRepository", "Lde/justsoftware/people/persistence/AbsenceRepository;", "transactionSupport", "Lde/justsoftware/people/persistence/transaction/TransactionSupport;", "externalLinkService", "Lde/justsoftware/people/business/externallink/ExternalLinkService;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/people/persistence/ProfileRepository;Lde/justsoftware/people/persistence/ProfileAttributeRepository;Lde/justsoftware/people/persistence/BirthdayReminderRepository;Lde/justsoftware/people/persistence/AbsenceRepository;Lde/justsoftware/people/persistence/transaction/TransactionSupport;Lde/justsoftware/people/business/externallink/ExternalLinkService;Lorg/springframework/context/ApplicationEventPublisher;)V", "changeAbsenceInformation", "", "profileId", "Lde/justsoftware/people/model/ProfileId;", "absenceInformation", "Lde/justsoftware/people/application/model/AbsenceInformation;", "deleteBirthdayReminder", "reminderProfileId", "findUndeletedProfileByIds", "", "Lde/justsoftware/people/business/profile/model/Profile;", "profileIds", "", "getAbsenceInformation", "getAbsenceOrDefault", "Lde/justsoftware/people/persistence/model/DbAbsence;", "kotlin.jvm.PlatformType", "id", "", "getBirthdayReminderProfiles", "", "profileIdsToCheck", "getProfile", "profileSearchReadModel", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "configuredLinks", "", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "onProfileAttributesChanged", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/model/DynamicProfileFields;", "onProfileAttributesChanged$people_api", "onProfileChanged", "Lde/justsoftware/people/business/profile/model/KafkaProfileDto;", "onProfileChanged$people_api", "saveBirthdayReminder", "saveProfileAttributes", "profileAttributes", "Lde/justsoftware/people/persistence/model/DbProfileAttribute;", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,206:1\n1549#2:207\n1620#2,3:208\n1360#2:211\n1446#2,5:212\n1549#2:217\n1620#2,3:218\n1360#2:221\n1446#2,2:222\n1620#2,3:225\n1448#2,3:228\n1194#2,2:231\n1222#2,4:233\n1194#2,2:237\n1222#2,4:239\n1549#2:247\n1620#2,3:248\n1549#2:251\n1620#2,3:252\n1855#2:258\n1856#2:262\n1271#2,2:264\n1285#2,2:266\n1288#2:269\n1238#2,4:272\n1194#2,2:276\n1222#2,4:278\n1238#2,4:284\n1549#2:288\n1620#2,3:289\n1855#2,2:292\n17#3:224\n7#3,3:255\n10#3,3:259\n13#3:263\n125#4:243\n152#4,3:244\n1#5:268\n468#6:270\n414#6:271\n453#6:282\n403#6:283\n494#6,7:294\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n*L\n85#1:207\n85#1:208,3\n87#1:211\n87#1:212,5\n96#1:217\n96#1:218,3\n98#1:221\n98#1:222,2\n101#1:225,3\n98#1:228,3\n102#1:231,2\n102#1:233,4\n113#1:237,2\n113#1:239,4\n117#1:247\n117#1:248,3\n118#1:251\n118#1:252,3\n123#1:258\n123#1:262\n131#1:264,2\n131#1:266,2\n131#1:269\n135#1:272,4\n156#1:276,2\n156#1:278,4\n157#1:284,4\n170#1:288\n170#1:289,3\n172#1:292,2\n101#1:224\n123#1:255,3\n123#1:259,3\n123#1:263\n114#1:243\n114#1:244,3\n135#1:270\n135#1:271\n157#1:282\n157#1:283\n176#1:294,7\n*E\n"})
public class ProfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final ProfileAttributeRepository profileAttributeRepository;
    @NotNull
    private final BirthdayReminderRepository birthdayReminderRepository;
    @NotNull
    private final AbsenceRepository absenceRepository;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ExternalLinkService externalLinkService;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    public static final String PERSON_TOPIC = "just.persons";
    @NotNull
    public static final String PERSON_PROFILE_ATTRIBUTES_TOPIC = "just.persons.profileAttributes";
    @NotNull
    private static final String PROFILE_LISTENER_ID = "profileConsumer";
    @NotNull
    private static final String PROFILE_ATTRIBUTES_LISTENER_ID = "profileAttributesConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileService.class);

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull ProfileAttributeRepository profileAttributeRepository, @NotNull BirthdayReminderRepository birthdayReminderRepository, @NotNull AbsenceRepository absenceRepository, @NotNull TransactionSupport transactionSupport, @NotNull ExternalLinkService externalLinkService, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)profileAttributeRepository, (String)"profileAttributeRepository");
        Intrinsics.checkNotNullParameter((Object)birthdayReminderRepository, (String)"birthdayReminderRepository");
        Intrinsics.checkNotNullParameter((Object)absenceRepository, (String)"absenceRepository");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)externalLinkService, (String)"externalLinkService");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.profileRepository = profileRepository;
        this.profileAttributeRepository = profileAttributeRepository;
        this.birthdayReminderRepository = birthdayReminderRepository;
        this.absenceRepository = absenceRepository;
        this.transactionSupport = transactionSupport;
        this.externalLinkService = externalLinkService;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel, @NotNull List<ExternalLinkConfig> configuredLinks) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        Intrinsics.checkNotNullParameter(configuredLinks, (String)"configuredLinks");
        Map fields = profileSearchReadModel.getFields();
        if (fields.isEmpty()) {
            return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
        }
        List links = this.externalLinkService.getLinkFromConfigAndData(configuredLinks, fields);
        return Profile.Companion.toProfile(profileSearchReadModel, links);
    }

    public void saveBirthdayReminder(@NotNull ProfileId profileId, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        this.birthdayReminderRepository.save((Object)new DbBirthdayReminder(((Number)profileId.getId()).longValue(), ((Number)reminderProfileId.getId()).longValue()));
    }

    public void deleteBirthdayReminder(@NotNull ProfileId profileId, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        this.birthdayReminderRepository.deleteById((Object)new DbBirthdayReminderId(((Number)profileId.getId()).longValue(), ((Number)reminderProfileId.getId()).longValue()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> getBirthdayReminderProfiles(@NotNull ProfileId profileId, @NotNull Set<ProfileId> profileIdsToCheck) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(profileIdsToCheck, (String)"profileIdsToCheck");
        Iterable iterable = profileIdsToCheck;
        ProfileId.Companion companion = ProfileId.Companion;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.birthdayReminderRepository.getBirthdayReminderProfileIds(((Number)profileId.getId()).longValue(), (Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return companion.toProfileIds((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findUndeletedProfileByIds(@NotNull Iterable<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable<ProfileId> $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable<ProfileId> iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)p0.getId()).longValue());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            List chunk = (List)element$iv$iv;
            boolean bl = false;
            Map attributes = DbProfileAttribute.Companion.toDynamicProfileFields((Iterable)this.profileAttributeRepository.findAllByProfileIdIn((Iterable)chunk));
            List profiles = this.profileRepository.findAllByDeletedIsFalseAndIdIn((Iterable)chunk);
            Iterable $this$mapToSet$iv = profiles;
            boolean $i$f$mapToSet = false;
            Iterable iterable2 = $this$mapToSet$iv;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbProfile dbProfile = (DbProfile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object2 = (DynamicProfileFields)attributes.get(new ProfileId(it.getId()));
                if (object2 == null || (object2 = object2.getFields()) == null) {
                    object2 = MapsKt.emptyMap();
                }
                collection.add(DbProfile.Companion.toProfile$default((DbProfile.Companion)DbProfile.Companion, (DbProfile)it, (Map)object2, null, (int)2, null));
            }
            Iterable list$iv$iv = (Set)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileConsumer", containerFactory="profileListenerFactory", topics={"just.persons"}, idIsGroup=false)
    public void onProfileChanged$people_api(@NotNull ConsumerRecords<ProfileId, KafkaProfileDto> records) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$mapTo$iv$iv3;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$map$iv3 = destination$iv$iv;
        boolean $i$f$map22 = false;
        Map capacity$iv22 = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv3.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv3.entrySet()) {
            Object element$iv$iv;
            element$iv$iv = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            ConsumerRecord record = (ConsumerRecord)element$iv$iv.getValue();
            Object object2 = record.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
            object.add(DbProfile.Companion.toDbProfile((KafkaProfileDto)object2));
        }
        List changedProfiles = (List)destination$iv$iv2;
        $this$mapTo$iv$iv3 = changedProfiles;
        object = this.profileRepository;
        boolean $i$f$map32 = false;
        void $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            DbProfile record = (DbProfile)item$iv$iv2;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv3));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        void $i$f$map32 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbProfile item$iv$iv2 = (DbProfile)item$iv$iv;
            object = destination$iv$iv22;
            boolean bl = false;
            object.add(p0.getId());
        }
        Set knownProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv22));
        this.profileRepository.saveAll((Iterable)changedProfiles);
        Iterable $this$partition$iv = changedProfiles;
        boolean $i$f$partition = false;
        ArrayList<DbProfile> first$iv = new ArrayList<DbProfile>();
        Iterable second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partition$iv;
        boolean $i$f$forEach = false;
        Iterator p0 = $this$forEach$iv$iv.iterator();
        while (p0.hasNext()) {
            void p02;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = p0.next();
            boolean bl = false;
            DbProfile p03 = (DbProfile)element$iv;
            boolean $i$a$-partition-ProfileService$onProfileChanged$32 = false;
            ArrayList<DbProfile> target$iv = p03.getDeleted() ? first$iv : second$iv;
            DbProfile $i$a$-partition-ProfileService$onProfileChanged$32 = (DbProfile)element$iv;
            object = target$iv;
            boolean bl2 = false;
            ((ArrayList)object).add(p02.getId());
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List deletedProfiles = (List)pair.component1();
        List updatedProfiles = (List)pair.component2();
        if (!((Collection)deletedProfiles).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesDeletedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)deletedProfiles)));
            LOG.info("Deleted " + ((Collection)deletedProfiles).size() + " profile(s)");
        }
        second$iv = CollectionsKt.minus((Iterable)updatedProfiles, (Iterable)knownProfiles);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            TenantId tenantId;
            DbProfile profile;
            Object v2;
            block13: {
                long target$iv = ((Number)element$iv$iv).longValue();
                collection = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Iterable iterable2 = changedProfiles;
                for (Object object3 : iterable2) {
                    void id;
                    DbProfile profile2 = (DbProfile)object3;
                    boolean bl3 = false;
                    if (!(profile2.getId() == id)) continue;
                    v2 = object3;
                    break block13;
                }
                v2 = null;
            }
            DbProfile dbProfile = profile = (DbProfile)v2;
            Intrinsics.checkNotNull((Object)dbProfile);
            if (dbProfile.getTenantId() == null) {
                tenantId = null;
            } else {
                UUID uUID = profile.getTenantId();
                Intrinsics.checkNotNull((Object)uUID);
                tenantId = new TenantId(uUID);
            }
            TenantId tenantId2 = tenantId;
            object.put(collection, tenantId2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void entry;
            Object object3;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv4;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = new ProfileId(((Number)entry.getKey()).longValue());
            Object object4 = object;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            object4.put(object3, v);
        }
        Map newProfilesAndTenant = destination$iv$iv4;
        if (!newProfilesAndTenant.isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesCreatedEvent((Object)this, newProfilesAndTenant));
            LOG.info("Added " + newProfilesAndTenant.size() + " profile(s)");
        }
        if (!((Collection)updatedProfiles).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)updatedProfiles)));
            LOG.info("Updated " + ((Collection)updatedProfiles).size() + " profile(s)");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileAttributesConsumer", containerFactory="profileAttributesListenerFactory", topics={"just.persons.profileAttributes"}, idIsGroup=false)
    public void onProfileAttributesChanged$people_api(@NotNull ConsumerRecords<ProfileId, DynamicProfileFields> records) {
        void $this$mapValuesTo$iv$iv;
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List list;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            ConsumerRecord records2 = (ConsumerRecord)entry.getValue();
            DynamicProfileFields dynamicProfileFields = (DynamicProfileFields)records2.value();
            if (dynamicProfileFields != null) {
                Intrinsics.checkNotNull((Object)profileId);
                list = DbProfileAttribute.Companion.toDbProfileAttributes(dynamicProfileFields, profileId);
            } else {
                list = null;
            }
            List list2 = list;
            map.put(k, list2);
        }
        Map attributeChanges = destination$iv$iv2;
        this.saveProfileAttributes(attributeChanges);
        LOG.info("Updated profile attributes of " + attributeChanges.size() + " profiles");
    }

    private void saveProfileAttributes(Map<ProfileId, ? extends List<DbProfileAttribute>> profileAttributes) {
        if (profileAttributes.isEmpty()) {
            return;
        }
        this.transactionSupport.doInTransaction(() -> ProfileService.saveProfileAttributes$lambda$19(profileAttributes, this));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, profileAttributes.keySet()));
    }

    private DbAbsence getAbsenceOrDefault(long id) {
        return this.absenceRepository.findById((Object)id).orElse(new DbAbsence(id, true));
    }

    @NotNull
    public AbsenceInformation getAbsenceInformation(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return new AbsenceInformation(Boolean.valueOf(this.getAbsenceOrDefault(((Number)profileId.getId()).longValue()).isAbsent()));
    }

    public void changeAbsenceInformation(@NotNull ProfileId profileId, @NotNull AbsenceInformation absenceInformation) {
        DbAbsence dbAbsence;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)absenceInformation, (String)"absenceInformation");
        DbAbsence $this$changeAbsenceInformation_u24lambda_u2420 = dbAbsence = this.getAbsenceOrDefault(((Number)profileId.getId()).longValue());
        boolean bl = false;
        Boolean bl2 = absenceInformation.isAbsent();
        $this$changeAbsenceInformation_u24lambda_u2420.setAbsent(bl2 != null ? bl2.booleanValue() : $this$changeAbsenceInformation_u24lambda_u2420.isAbsent());
        DbAbsence absenceToUpdate = dbAbsence;
        this.absenceRepository.save((Object)absenceToUpdate);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveProfileAttributes$lambda$19(Map $profileAttributes, ProfileService this$0) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$profileAttributes, (String)"$profileAttributes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$map$iv = $profileAttributes.keySet();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileAttributeRepository $i$f$map22 = this$0.profileAttributeRepository;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            $i$f$map22.deleteByProfileIdIn(p0);
        }
        Map $this$filterValues$iv = CollectionUtilsKt.filterNotNullValues((Map)$profileAttributes);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List p0 = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(!((Collection)p0).isEmpty())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List toSave = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        if (!((Collection)toSave).isEmpty()) {
            this$0.profileAttributeRepository.saveAll((Iterable)toSave);
        }
    }
}

