/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.application.model.CreateLinkDto;
import de.justsoftware.people.application.utils.JustJavascriptUtils;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.models.StaticAction;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.LinkConfigCreateModel;
import de.justsoftware.people.config.ConfigService;
import de.justsoftware.people.model.AbstractId;
import de.justsoftware.people.model.ExternalLinkId;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0012J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/people/application/ConfigApplicationService;", "", "linkService", "Lde/justsoftware/people/business/externallink/ExternalLinkService;", "configService", "Lde/justsoftware/people/config/ConfigService;", "(Lde/justsoftware/people/business/externallink/ExternalLinkService;Lde/justsoftware/people/config/ConfigService;)V", "createExternalLink", "Lde/justsoftware/people/model/ExternalLinkId;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "createLinkDto", "Lde/justsoftware/people/application/model/CreateLinkDto;", "authorizationContext", "Lde/justsoftware/people/authorization/AuthorizationContext;", "deleteExternalLinks", "", "linkIds", "", "escape", "", "input", "getExternalLinks", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "isAbsenceEnabled", "", "isBirthdayListEnabled", "people-api"})
public class ConfigApplicationService {
    @NotNull
    private final ExternalLinkService linkService;
    @NotNull
    private final ConfigService configService;

    public ConfigApplicationService(@NotNull ExternalLinkService linkService, @NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.linkService = linkService;
        this.configService = configService;
    }

    @NotNull
    public ExternalLinkId createExternalLink(@NotNull TenantId tenantId, @NotNull CreateLinkDto createLinkDto, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)createLinkDto, (String)"createLinkDto");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.check(StaticAction.MANAGE, (AbstractId)tenantId);
        ProfileId profileId = authorizationContext.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        ProfileId linkCreator = profileId;
        LinkConfigCreateModel safeExternalLink = new LinkConfigCreateModel(this.escape(createLinkDto.getUri()), this.escape(createLinkDto.getDescription()));
        return this.linkService.createExternalLink(tenantId, safeExternalLink, linkCreator);
    }

    @NotNull
    public List<ExternalLinkConfig> getExternalLinks(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.check(StaticAction.READ, (AbstractId)tenantId);
        return this.linkService.getConfiguredLinks(tenantId);
    }

    public void deleteExternalLinks(@NotNull TenantId tenantId, @NotNull List<ExternalLinkId> linkIds, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(linkIds, (String)"linkIds");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.check(StaticAction.MANAGE, (AbstractId)tenantId);
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)linkIds);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"copyOf(...)");
        this.linkService.deleteExternalLinks(tenantId, (Set)immutableSet);
    }

    public boolean isBirthdayListEnabled(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        TenantId tenantId = authorizationContext.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        return this.configService.isBirthdayListEnabled(tenantId);
    }

    public boolean isAbsenceEnabled(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        TenantId tenantId = authorizationContext.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        return this.configService.isAbsenceEnabled(tenantId);
    }

    private String escape(String input) {
        String string = JustJavascriptUtils.javaScriptEscape((String)input);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaScriptEscape(...)");
        return string;
    }
}

