/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.util;

import de.justsoftware.notificationservice.exception.UnauthorizedException;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/justsoftware/notificationservice/util/ControllerUtil;", "", "()V", "currentProfileId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "getCurrentProfileId", "()Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "notification-service"})
public final class ControllerUtil {
    @NotNull
    public static final ControllerUtil INSTANCE = new ControllerUtil();

    private ControllerUtil() {
    }

    @NotNull
    public final ProfileId getCurrentProfileId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        Object object = authentication.getPrincipal();
        if (object == null) {
            object = new IllegalStateException("Expected principal not to be null.");
        }
        Object principal = object;
        return new ProfileId(principal.toString());
    }
}

