/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.persistence;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusCount;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@ParametersAreNonnullByDefault
public interface DeliveryStatusRepository
extends JpaRepository<DbDeliveryStatus, DbDeliveryStatusId> {
    public static final int MAX_IN_CLAUSE_PARAMS = 1000;

    @Nonnull
    @Query(value="SELECT deliveryStatus FROM DbDeliveryStatus deliveryStatus INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id WHERE deliveryStatus.receiverId = :receiverId AND deliveryStatus.status = :status AND notification.type IN :types AND notification.timestamp < :timestamp")
    public Page<DbDeliveryStatus> findNotifications(@Param(value="receiverId") String var1, @Param(value="status") NotificationStatus var2, @Param(value="timestamp") Instant var3, @Param(value="types") Set<NotificationType> var4, Pageable var5);

    @Nonnull
    @Query(value="SELECT deliveryStatus FROM DbDeliveryStatus deliveryStatus INNER JOIN DbNotification notification ON deliveryStatus.notificationId = notification.id WHERE deliveryStatus.receiverId = :receiverId AND deliveryStatus.status = :status AND notification.type IN :types AND notification.appId = :app AND notification.timestamp < :timestamp")
    public Page<DbDeliveryStatus> findNotificationsByApp(@Param(value="receiverId") String var1, @Param(value="status") NotificationStatus var2, @Param(value="timestamp") Instant var3, @Param(value="types") Set<NotificationType> var4, @Param(value="app") String var5, Pageable var6);

    @Nonnull
    public List<DbDeliveryStatus> findAllByShouldTriggerMailAndStatusOrderByReceiverId(boolean var1, NotificationStatus var2);

    @Modifying
    @Transactional
    default public int setArchived(@Param(value="receiverId") String receiverId, @Param(value="notificationId") UUID notificationId, @Param(value="updatedAt") Instant updatedAt) {
        return this.setArchived((Set)ImmutableSet.of((Object)notificationId), receiverId, updatedAt);
    }

    public int deleteByReceiverId(@Param(value="receiverId") String var1);

    @Transactional
    default public int setArchived(@Param(value="notificationIds") Set<UUID> notificationIds2, @Param(value="receiverId") String receiverId, @Param(value="updatedAt") Instant updatedAt) {
        AtomicInteger count = new AtomicInteger(0);
        Iterators.partition(notificationIds2.iterator(), (int)1000).forEachRemaining(batchOfNotificationIds -> count.addAndGet(this.setArchivedUnbatched(batchOfNotificationIds, receiverId, updatedAt)));
        return count.get();
    }

    @Modifying
    @Query(value="UPDATE DbDeliveryStatus d SET d.status = 'ARCHIVED', d.shouldTriggerMail = false, d.marked = false, d.updatedAt = :updatedAt WHERE d.notificationId IN :notificationIds AND d.receiverId = :receiverId")
    @Deprecated
    public int setArchivedUnbatched(@Param(value="notificationIds") List<UUID> var1, @Param(value="receiverId") String var2, @Param(value="updatedAt") Instant var3);

    @Nonnull
    @Query(value="SELECT d FROM DbDeliveryStatus d INNER JOIN DbNotification n ON d.notificationId = n.id WHERE d.receiverId = :receiverId AND d.status = 'OPEN' AND n.type IN :types AND d.marked = false")
    public List<DbDeliveryStatus> findAllOpenAndUnmarked(@Param(value="receiverId") String var1, @Param(value="types") Set<NotificationType> var2);

    @Nonnull
    @Query(value="SELECT d FROM DbDeliveryStatus d INNER JOIN DbNotification n ON d.notificationId = n.id WHERE d.receiverId = :receiverId AND d.status = 'OPEN' AND n.type IN :types AND n.appId = :app AND d.marked = false")
    public List<DbDeliveryStatus> findAllOpenAndUnmarkedByApp(@Param(value="receiverId") String var1, @Param(value="types") Set<NotificationType> var2, @Param(value="app") String var3);

    @Modifying
    @Query(value="UPDATE DbDeliveryStatus d SET d.status = 'ARCHIVED', d.shouldTriggerMail = false, d.marked = false, d.updatedAt = :updatedAt WHERE d.receiverId = :receiverId AND d.status = 'OPEN' AND d.marked = false AND d.notificationId IN ( SELECT n.id FROM DbNotification n WHERE n.id = d.notificationId AND n.type IN :types AND n.targetId = :targetId)")
    @Transactional
    public int archiveAllByTarget(@Param(value="targetId") String var1, @Param(value="types") Set<NotificationType> var2, @Param(value="receiverId") String var3, @Param(value="updatedAt") Instant var4);

    @Query(value="SELECT DISTINCT d.receiverId FROM DbDeliveryStatus d WHERE d.shouldTriggerMail = true")
    @Nonnull
    public List<String> distinctReceivers();

    @Modifying
    @Deprecated
    @Query(value="UPDATE DbDeliveryStatus d SET d.shouldTriggerMail = false WHERE d IN :status")
    public int disableMailTriggersUnbatched(@Param(value="status") List<DbDeliveryStatus> var1);

    @Transactional
    default public int disableMailTriggers(@Param(value="status") List<DbDeliveryStatus> status) {
        AtomicInteger count = new AtomicInteger();
        Iterators.partition(status.iterator(), (int)1000).forEachRemaining(batchOfStatus -> count.addAndGet(this.disableMailTriggersUnbatched(batchOfStatus)));
        return count.get();
    }

    public int countByReceiverIdAndStatus(String var1, NotificationStatus var2);

    @Query(value="SELECT count(ds.notificationId) from DbDeliveryStatus ds WHERE ds.updatedAt > :since AND ds.receiverId = :receiverId")
    public int countUpdatesForReceiverSinceTimestamp(@Param(value="receiverId") String var1, @Param(value="since") Instant var2);

    @Query(value="SELECT d FROM DbDeliveryStatus d WHERE d.receiverId IN :receiverIds AND d.shouldTriggerMail = true ORDER BY d.receiverId")
    @Nonnull
    @Deprecated
    public List<DbDeliveryStatus> getStatusWithActiveTriggerForReceiversUnbatched(@Param(value="receiverIds") List<String> var1);

    @Nonnull
    default public List<DbDeliveryStatus> getStatusWithActiveTriggerForReceivers(List<String> receiverIds) {
        ArrayList<DbDeliveryStatus> status = new ArrayList<DbDeliveryStatus>();
        Iterators.partition(receiverIds.iterator(), (int)1000).forEachRemaining(batchOfReceiverIds -> status.addAll(this.getStatusWithActiveTriggerForReceiversUnbatched(batchOfReceiverIds)));
        return status;
    }

    @Query(value="SELECT new de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusCount(ds.receiverId, count(ds)) FROM DbDeliveryStatus ds WHERE ds.receiverId IN :receiverIds AND ds.status = :status GROUP BY ds.receiverId")
    @Nonnull
    @Deprecated
    public List<DbDeliveryStatusCount> countByReceiverIdsAndStatusAsList(@Param(value="receiverIds") List<String> var1, @Param(value="status") NotificationStatus var2);

    @Nonnull
    default public ImmutableMap<String, Integer> countByReceiverIdsAndStatus(Set<String> receiverIds, NotificationStatus status) {
        HashMap counts = new HashMap();
        Iterators.partition(receiverIds.iterator(), (int)1000).forEachRemaining(batchOfReceiverIds -> counts.putAll((Map)this.countByReceiverIdsAndStatusAsList(batchOfReceiverIds, status).stream().collect(ImmutableMap.toImmutableMap(DbDeliveryStatusCount::getReceiverId, ds -> Math.toIntExact(ds.getCount())))));
        return ImmutableMap.copyOf(counts);
    }

    @Modifying
    @Query(value="UPDATE DbDeliveryStatus d SET d.status = 'OPEN', d.marked = true, d.updatedAt = :updatedAt WHERE d.notificationId = :notificationId AND d.receiverId = :receiverId")
    @Transactional
    public int mark(@Param(value="receiverId") String var1, @Param(value="notificationId") UUID var2, @Param(value="updatedAt") Instant var3);

    @Modifying
    @Query(value="UPDATE DbDeliveryStatus d SET d.marked = false, d.updatedAt = :updatedAt WHERE d.notificationId = :notificationId AND d.receiverId = :receiverId")
    @Transactional
    public int unmark(@Param(value="receiverId") String var1, @Param(value="notificationId") UUID var2, @Param(value="updatedAt") Instant var3);

    @Modifying
    @Query(value="UPDATE DbDeliveryStatus d SET d.status = 'OPEN', d.updatedAt = :updatedAt WHERE d.notificationId IN :notificationIds AND d.receiverId = :receiverId AND d.status = 'ARCHIVED'")
    @Deprecated
    public int setOpenUnbatched(@Param(value="notificationIds") List<UUID> var1, @Param(value="receiverId") String var2, @Param(value="updatedAt") Instant var3);

    @Transactional
    default public int setOpen(@Param(value="notificationIds") List<UUID> notificationIds2, @Param(value="receiverId") String receiverId, @Param(value="updatedAt") Instant updatedAt) {
        AtomicInteger count = new AtomicInteger(0);
        Iterators.partition(notificationIds2.iterator(), (int)1000).forEachRemaining(batchOfNotificationIds -> count.addAndGet(this.setOpenUnbatched(batchOfNotificationIds, receiverId, updatedAt)));
        return count.get();
    }

    @Nonnull
    @Transactional
    @Deprecated
    public Page<DbDeliveryStatus> findByReceiverIdAndStatusAndMarkedAndShouldTriggerMail(String var1, NotificationStatus var2, boolean var3, boolean var4, Pageable var5);
}

