/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.util;

import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u000f\u00a8\u0006\u0012"}, d2={"itemIdOf", "Lde/justsoftware/wikiservice/model/ItemId;", "id", "Ljava/util/UUID;", "idType", "Lde/justsoftware/wikiservice/model/IdType;", "idString", "", "parentIdOf", "Lde/justsoftware/wikiservice/model/ParentId;", "parseLongId", "", "longId", "(Ljava/lang/String;)Ljava/lang/Long;", "toAbstractId", "Lde/justsoftware/wikiservice/model/AbstractId;", "Lde/justsoftware/search/shared/model/SearchableId;", "toSearchableId", "wiki-service"})
public final class IdUtilsKt {
    @NotNull
    public static final ParentId parentIdOf(@NotNull UUID id, @NotNull IdType idType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)idType, (String)"idType");
        return switch (WhenMappings.$EnumSwitchMapping$0[idType.ordinal()]) {
            case 1 -> (ParentId)new ChapterId(id);
            case 2 -> (ParentId)new WikiId(id);
            default -> throw new IllegalArgumentException(idType + " is not a parent type");
        };
    }

    @NotNull
    public static final ParentId parentIdOf(@NotNull String idString) {
        ParentId parentId;
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        if (StringsKt.startsWith$default((String)idString, (String)"WIKI_WIKI", (boolean)false, (int)2, null)) {
            parentId = (ParentId)new WikiId(idString);
        } else if (StringsKt.startsWith$default((String)idString, (String)"WIKI_CHAPTER", (boolean)false, (int)2, null)) {
            parentId = (ParentId)new ChapterId(idString);
        } else {
            throw new IllegalArgumentException("Unknown parent type " + idString);
        }
        return parentId;
    }

    @NotNull
    public static final ItemId itemIdOf(@NotNull UUID id, @NotNull IdType idType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)idType, (String)"idType");
        return switch (WhenMappings.$EnumSwitchMapping$0[idType.ordinal()]) {
            case 2 -> (ItemId)new WikiId(id);
            case 1 -> (ItemId)new ChapterId(id);
            case 3 -> (ItemId)new ArticleId(id);
            default -> throw new IllegalArgumentException(idType + " is not an item type");
        };
    }

    @NotNull
    public static final ItemId itemIdOf(@NotNull String idString) {
        ItemId itemId;
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        if (StringsKt.startsWith$default((String)idString, (String)"WIKI_WIKI", (boolean)false, (int)2, null)) {
            itemId = (ItemId)new WikiId(idString);
        } else if (StringsKt.startsWith$default((String)idString, (String)"WIKI_CHAPTER", (boolean)false, (int)2, null)) {
            itemId = (ItemId)new ChapterId(idString);
        } else if (StringsKt.startsWith$default((String)idString, (String)"WIKI_ARTICLE", (boolean)false, (int)2, null)) {
            itemId = (ItemId)new ArticleId(idString);
        } else {
            throw new IllegalArgumentException("Unknown item type " + idString);
        }
        return itemId;
    }

    @Nullable
    public static final Long parseLongId(@NotNull String longId) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)longId, (String)"longId");
        Object object = new String[]{","};
        List idParts = StringsKt.split$default((CharSequence)longId, (String[])object, (boolean)false, (int)0, (int)6, null);
        if (idParts.size() != 2) {
            stringArray = null;
        } else {
            try {
                object = Long.parseLong((String)idParts.get(1));
            }
            catch (NumberFormatException ex) {
                object = null;
            }
            stringArray = object;
        }
        return stringArray;
    }

    @NotNull
    public static final SearchableId toSearchableId(@NotNull AbstractId $this$toSearchableId) {
        Intrinsics.checkNotNullParameter((Object)$this$toSearchableId, (String)"<this>");
        String string = $this$toSearchableId.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new SearchableId(string, $this$toSearchableId.type().name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final AbstractId toAbstractId(@NotNull SearchableId $this$toAbstractId) {
        AbstractId abstractId;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$toAbstractId, (String)"<this>");
            String string = $this$toAbstractId.getType();
            switch (string.hashCode()) {
                case 2001860423: {
                    if (!string.equals("WIKI_ARTICLE")) {
                        throw new IllegalStateException(("Unsupported abstract id " + $this$toAbstractId.getType()).toString());
                    }
                    break block6;
                }
                case -821713250: {
                    if (string.equals("WIKI_CHAPTER")) break;
                    throw new IllegalStateException(("Unsupported abstract id " + $this$toAbstractId.getType()).toString());
                }
                case 65013471: {
                    if (!string.equals("WIKI_WIKI")) throw new IllegalStateException(("Unsupported abstract id " + $this$toAbstractId.getType()).toString());
                    abstractId = (AbstractId)new WikiId($this$toAbstractId.toCanonicalId());
                    return abstractId;
                }
            }
            abstractId = (AbstractId)new ChapterId($this$toAbstractId.toCanonicalId());
            return abstractId;
        }
        abstractId = (AbstractId)new ArticleId($this$toAbstractId.toCanonicalId());
        return abstractId;
        throw new IllegalStateException(("Unsupported abstract id " + $this$toAbstractId.getType()).toString());
    }
}

