/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.wikiservice.application.ExportApplicationService;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.controller.ExportController;
import de.justsoftware.wikiservice.controller.model.ArticleExportDto;
import de.justsoftware.wikiservice.exception.BadRequestException;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/export"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/wikiservice/controller/ExportController;", "", "exportApplicationService", "Lde/justsoftware/wikiservice/application/ExportApplicationService;", "(Lde/justsoftware/wikiservice/application/ExportApplicationService;)V", "exportArticles", "", "Lde/justsoftware/wikiservice/controller/model/ArticleExportDto;", "modifiedAfter", "Ljava/time/Instant;", "offset", "", "limit", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "Companion", "wiki-service"})
public class ExportController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportApplicationService exportApplicationService;
    public static final int MAX_EXPORT_LIMIT = 1000;

    public ExportController(@NotNull ExportApplicationService exportApplicationService) {
        Intrinsics.checkNotNullParameter((Object)exportApplicationService, (String)"exportApplicationService");
        this.exportApplicationService = exportApplicationService;
    }

    @GetMapping(value={"articles"})
    @NotNull
    public List<ArticleExportDto> exportArticles(@RequestParam(value="modifiedAfter", required=false) @Nullable Instant modifiedAfter, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="50") int limit, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (limit > 1000) {
            throw new BadRequestException("Limit of " + limit + " exceeds the max limit of 1000.");
        }
        return this.exportApplicationService.exportArticles(modifiedAfter, offset, limit, authContext);
    }
}

