/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.config.AuthContextResolver;
import de.justsoftware.wikiservice.exception.UnauthorizedException;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0002J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u001c\u0010 \u001a\u00020!2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/wikiservice/config/AuthContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "toroBaseUrl", "", "authService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rest", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/web/client/RestTemplate;)V", "currentPersonInfo", "", "authentication", "Lorg/springframework/security/oauth2/server/resource/authentication/BearerTokenAuthentication;", "profileId", "Lde/justsoftware/wikiservice/model/ProfileId;", "Lde/justsoftware/jwtfilter/JwtAuthenticationToken;", "resolveArgument", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "parameter", "Lorg/springframework/core/MethodParameter;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "supportsParameter", "", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAuthContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthContextResolver.kt\nde/justsoftware/wikiservice/config/AuthContextResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,161:1\n1179#2,2:162\n1253#2,4:164\n8#3:168\n7#3,3:169\n*S KotlinDebug\n*F\n+ 1 AuthContextResolver.kt\nde/justsoftware/wikiservice/config/AuthContextResolver\n*L\n98#1:162,2\n98#1:164,4\n158#1:168\n158#1:169,3\n*E\n"})
public final class AuthContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RestTemplate rest;
    @NotNull
    private static final Logger LOG;

    public AuthContextResolver(@NotNull String toroBaseUrl, @NotNull AuthorizationService authService, @NotNull WikiService wikiService, @NotNull ObjectMapper objectMapper, @NotNull RestTemplate rest) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.toroBaseUrl = toroBaseUrl;
        this.authService = authService;
        this.wikiService = wikiService;
        this.objectMapper = objectMapper;
        this.rest = rest;
    }

    public /* synthetic */ AuthContextResolver(String string, AuthorizationService authorizationService, WikiService wikiService, ObjectMapper objectMapper, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, authorizationService, wikiService, objectMapper, restTemplate);
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        AuthContext authContext;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        Authentication authentication2 = authentication;
        if ((authentication = authentication2) instanceof JwtAuthenticationToken) {
            authContext = new AuthContext(this.profileId((JwtAuthenticationToken)authentication2), this.tenantId((JwtAuthenticationToken)authentication2), this.authService, this.wikiService);
        } else if (authentication instanceof BearerTokenAuthentication) {
            Map currentPersonInfo = this.currentPersonInfo((BearerTokenAuthentication)authentication2);
            authContext = new AuthContext(this.profileId(currentPersonInfo), this.tenantId(currentPersonInfo), this.authService, this.wikiService);
        } else {
            LOG.warn("We received an unknown type of authentication: " + authentication2.getClass().getName());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return authContext;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> currentPersonInfo(BearerTokenAuthentication authentication) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + ((OAuth2AccessToken)authentication.getToken()).getTokenValue());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.rest.exchange(this.toroBaseUrl + "/api/v1/person/current", HttpMethod.GET, request, String.class, new Object[0]);
        boolean bl = false;
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.warn("Failed to retrieve person info from toro internal API: " + response.getStatusCode());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        Iterable iterable = ((Map)this.objectMapper.readValue((String)response.getBody(), Map.class)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Object key = entry.getKey();
            Object value = entry.getValue();
            entry = TuplesKt.to((Object)String.valueOf(key), (Object)String.valueOf(value));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    private final ProfileId profileId(JwtAuthenticationToken authentication) {
        ProfileId profileId;
        String principal = authentication.getPrincipal().toString();
        try {
            profileId = new ProfileId(principal);
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable profile ID: '" + principal + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final ProfileId profileId(Map<String, String> currentPersonInfo) {
        ProfileId profileId;
        String profileIdString = currentPersonInfo.get("id");
        if (profileIdString == null) {
            LOG.warn("Failed to extract profile id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            profileId = new ProfileId(profileIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable profile ID from toro: '" + profileIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final TenantId tenantId(JwtAuthenticationToken authentication) {
        TenantId tenantId;
        Object object = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (object == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        Object tenantId2 = object;
        try {
            tenantId = new TenantId(tenantId2.toString());
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable tenant ID: '" + tenantId2 + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    private final TenantId tenantId(Map<String, String> currentPersonInfo) {
        TenantId tenantId;
        String tenantIdString = currentPersonInfo.get("tenantId");
        if (tenantIdString == null) {
            LOG.warn("Failed to extract tenant id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            tenantId = new TenantId(tenantIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable tenant ID from toro: '" + tenantIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

