/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.exceptions.ChapterNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.EmptyChapterTitleException;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0017J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001bH\u0017J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 H\u0017J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0012J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0017J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0016J\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00140\u000e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0016J(\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140/0\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0016J&\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140/2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u0010H\u0017J\u0016\u00105\u001a\u00020\u001e2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0017J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020 08H\u0016J,\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020 2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010;\u001a\u00020\u001b2\b\b\u0002\u0010<\u001a\u00020'H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lde/justsoftware/wikiservice/business/ChapterService;", "", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "countByWikiIds", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "create", "Lde/justsoftware/wikiservice/business/model/ChapterDto;", "wiki", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "title", "", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "position", "delete", "", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleter", "deleteWikiChapters", "wikiId", "exists", "", "getAllChapterDescendantsByChapterParentIds", "parentChapterIds", "read", "readAllIds", "readByIds", "ids", "readByParentIds", "", "parentIds", "readBySubscriber", "subscriber", "page", "limit", "removeDeletedChapters", "deletionIds", "streamAllIds", "Ljava/util/stream/Stream;", "update", "id", "updater", "chapterWasMoved", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nChapterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChapterService.kt\nde/justsoftware/wikiservice/business/ChapterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1603#2,9:222\n1855#2:231\n1856#2:233\n1612#2:234\n1179#2,2:235\n1253#2,4:237\n1549#2:241\n1620#2,3:242\n1271#2,2:245\n1285#2,4:247\n1549#2:251\n1620#2,3:252\n1549#2:255\n1620#2,3:256\n1#3:232\n*S KotlinDebug\n*F\n+ 1 ChapterService.kt\nde/justsoftware/wikiservice/business/ChapterService\n*L\n52#1:222,9\n52#1:231\n52#1:233\n52#1:234\n62#1:235,2\n62#1:237,4\n74#1:241\n74#1:242,3\n81#1:245,2\n81#1:247,4\n193#1:251\n193#1:252,3\n205#1:255\n205#1:256,3\n52#1:232\n*E\n"})
public class ChapterService {
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public ChapterService(@NotNull ChapterRepository chapterRepository, @NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.chapterRepository = chapterRepository;
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<ChapterDto> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<ChapterDto> list = this.chapterRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().map(arg_0 -> ChapterService.readBySubscriber$lambda$0((Function1)readBySubscriber.1.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public ChapterDto read(@NotNull ChapterId chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Object object = this.chapterRepository.getReferenceById((Object)chapterId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return ChapterDto.Companion.toChapterDto((Chapter)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChapterId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.chapterRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChapterId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Stream<ChapterId> streamAllIds() {
        return this.chapterRepository.streamAllIds();
    }

    @Transactional
    public boolean exists(@NotNull ChapterId chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        return this.chapterRepository.existsById((Object)chapterId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChapterId, ChapterDto> readByIds(@NotNull Set<ChapterId> ids) {
        Map map;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, ids, null, (int)2, null);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                ChapterId id;
                Map map2 = destination$iv$iv;
                Chapter it = (Chapter)element$iv$iv;
                boolean bl = false;
                if (it.getId() == null) {
                    throw new ChapterNotFoundException(null, 1, null);
                }
                Pair pair = TuplesKt.to((Object)id, (Object)ChapterDto.Companion.toChapterDto(it));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ChapterDto>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Map fromDB = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, parentIds, null, (int)2, null);
        Iterable $this$map$iv = parentIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)fromDB.get(it);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list;
            void var13_13 = it;
            boolean $i$f$map2 = false;
            void var15_15 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void chapter;
                Chapter chapter2 = (Chapter)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(ChapterDto.Companion.toChapterDto((Chapter)chapter));
            }
            collection.add(TuplesKt.to((Object)var13_13, (Object)((List)destination$iv$iv2)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map countsByWiki = this.chapterRepository.countByWikiIds(wikiIds);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it, 0L)).longValue();
            map.put(t, n);
        }
        return MapsKt.toMap((Map)result$iv);
    }

    @Transactional
    @NotNull
    public ChapterDto create(@NotNull WikiId wiki, @NotNull ParentId parentId, @NotNull String title, @NotNull ProfileId creator, int position) {
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyChapterTitleException();
        }
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
        Object object = this.chapterRepository.saveAndFlush((Object)new Chapter(wiki, parentId, string, creator, null, Integer.valueOf(position), 16, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saveAndFlush(...)");
        Object it = object = ChapterDto.Companion.toChapterDto((Chapter)object);
        boolean bl = false;
        ParentId parentId2 = it.getParentId();
        Instant instant = it.getUpdatedAt().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId2, instant, it.getUpdatedBy());
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return object;
    }

    @Transactional
    @NotNull
    public ChapterDto update(@NotNull ChapterId id, @Nullable String title, @NotNull ProfileId updater, boolean chapterWasMoved) {
        ChapterDto chapterDto;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (title != null && StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyChapterTitleException();
        }
        Chapter chapter = (Chapter)this.chapterRepository.getReferenceById((Object)id);
        if ((title == null || Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)title)).toString(), (Object)chapter.getTitle())) && !chapterWasMoved) {
            Intrinsics.checkNotNull((Object)chapter);
            return ChapterDto.Companion.toChapterDto(chapter);
        }
        if (title != null) {
            String string = StringUtils.normalizeSpace((String)title);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
            chapter.setTitle(string);
        }
        chapter.setModifiedBy(updater);
        Object object = this.chapterRepository.saveAndFlush((Object)chapter);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saveAndFlush(...)");
        ChapterDto it = chapterDto = ChapterDto.Companion.toChapterDto((Chapter)object);
        boolean bl = false;
        ParentId parentId = it.getParentId();
        Instant instant = it.getUpdatedAt().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, it.getUpdatedBy());
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return chapterDto;
    }

    public static /* synthetic */ ChapterDto update$default(ChapterService chapterService, ChapterId chapterId, String string, ProfileId profileId, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return chapterService.update(chapterId, string, profileId, bl);
    }

    @Transactional
    public void delete(@NotNull ChapterId chapterId, @NotNull DeletionId deletionId, @NotNull ProfileId deleter) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deleter, (String)"deleter");
        Chapter chapterToDelete = (Chapter)this.chapterRepository.getReferenceById((Object)chapterId);
        Intrinsics.checkNotNull((Object)chapterToDelete);
        ParentId parentId = Chapter.Companion.getParent(chapterToDelete);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deleter);
        Set descendantChapterIds = this.getAllChapterDescendantsByChapterParentIds(SetsKt.setOf((Object)chapterId));
        Set toDeletedChapterIds = CollectionsKt.union((Iterable)SetsKt.setOf((Object)chapterId), (Iterable)descendantChapterIds);
        this.chapterRepository.deleteByIds(toDeletedChapterIds, deletionId);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.articleService.deleteByParentIds(toDeletedChapterIds, deletionId);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ChapterId> getAllChapterDescendantsByChapterParentIds(Set<ChapterId> parentChapterIds) {
        Set descendants = new LinkedHashSet();
        Set nextParentChapterIds = parentChapterIds;
        while (!((Collection)nextParentChapterIds).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.flatten((Iterable)ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, nextParentChapterIds, null, (int)2, null).values());
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Chapter chapter = (Chapter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ChapterId chapterId = it.getId();
                if (chapterId == null) {
                    throw new ChapterNotFoundException(null, 1, null);
                }
                collection.add(chapterId);
            }
            Set childrenChapterIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            descendants.addAll(childrenChapterIds);
            nextParentChapterIds = childrenChapterIds;
        }
        return descendants;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteWikiChapters(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable iterable = this.chapterRepository.deleteByWikiId(wikiId, deletionId);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ChapterId chapterId = it.getId();
            if (chapterId == null) {
                throw new ChapterNotFoundException(null, 1, null);
            }
            collection.add(chapterId);
        }
        Set deletedChapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void removeDeletedChapters(@NotNull Set<DeletionId> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        this.chapterRepository.deleteAllByDeletionIds(deletionIds);
    }

    private static final ChapterDto readBySubscriber$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChapterDto)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChapterService $this) {
        return $this.applicationEventPublisher;
    }
}

