/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.DuplicateGranteeIdException;
import de.justsoftware.wikiservice.business.model.PermissionDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.generated.SetPermissionItemInput;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "getPermissionsForWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "Lde/justsoftware/wikiservice/business/model/PermissionDto;", "wikiIds", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "republishPermissions", "", "setPermissions", "wikiId", "newPermissions", "Lde/justsoftware/wikiservice/graphql/generated/SetPermissionItemInput;", "setPermissionsForWikiCreation", "permissions", "setPermissionsForWikiUpdate", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nPermissionApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionApplicationService.kt\nde/justsoftware/wikiservice/application/PermissionApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,108:1\n1603#2,9:109\n1855#2:118\n1856#2:120\n1612#2:121\n1603#2,9:122\n1855#2:131\n1856#2:133\n1612#2:134\n1603#2,9:135\n1855#2:144\n1856#2:146\n1612#2:147\n1603#2,9:148\n1855#2:157\n1856#2:159\n1612#2:160\n1855#2,2:161\n1490#2:163\n1520#2,3:164\n1523#2,3:174\n1#3:119\n1#3:132\n1#3:145\n1#3:158\n372#4,7:167\n*S KotlinDebug\n*F\n+ 1 PermissionApplicationService.kt\nde/justsoftware/wikiservice/application/PermissionApplicationService\n*L\n49#1:109,9\n49#1:118\n49#1:120\n49#1:121\n50#1:122,9\n50#1:131\n50#1:133\n50#1:134\n70#1:135,9\n70#1:144\n70#1:146\n70#1:147\n72#1:148,9\n72#1:157\n72#1:159\n72#1:160\n79#1:161,2\n88#1:163\n88#1:164,3\n88#1:174,3\n49#1:119\n50#1:132\n70#1:145\n72#1:158\n88#1:167,7\n*E\n"})
public class PermissionApplicationService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public PermissionApplicationService(@NotNull PermissionService permissionService, @NotNull WikiService wikiService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.permissionService = permissionService;
        this.wikiService = wikiService;
        this.authorizationService = authorizationService;
    }

    public void republishPermissions() {
        this.permissionService.republishPermissions();
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiUpdate(@NotNull WikiId wikiId, @NotNull List<SetPermissionItemInput> permissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        return this.setPermissions(wikiId, permissions, authContext);
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiCreation(@NotNull WikiId wikiId, @NotNull List<SetPermissionItemInput> permissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        return this.setPermissions(wikiId, permissions, authContext);
    }

    /*
     * WARNING - void declaration
     */
    private List<PermissionDto> setPermissions(WikiId wikiId, List<SetPermissionItemInput> newPermissions, AuthContext authContext) {
        void $this$groupByTo$iv$iv;
        Iterable element$iv2;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv4;
        Iterable $this$mapNotNull$iv = newPermissions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ProfileId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv4;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            SetPermissionItemInput it = (SetPermissionItemInput)element$iv$iv;
            boolean bl2 = false;
            if (it.getGranteeId().toProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = newPermissions;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        Iterable $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            SetPermissionItemInput it = (SetPermissionItemInput)element$iv$iv;
            boolean bl4 = false;
            if (it.getGranteeId().toUserGroupId() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set newUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (newPermissions.size() != newProfiles.size() + newUserGroups.size()) {
            throw new DuplicateGranteeIdException();
        }
        WikiDto wikiToUpdate = this.wikiService.read(wikiId);
        List currentPermissions = this.permissionService.getPermissionsByWikiId(wikiId);
        Iterable $this$mapNotNull$iv3 = currentPermissions;
        boolean $i$f$mapNotNull3 = false;
        $this$forEach$iv$iv$iv2 = $this$mapNotNull$iv3;
        Iterable<ProfileId> destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach3 = false;
        Iterator bl = $this$forEach$iv$iv$iv3.iterator();
        while (bl.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = bl.next();
            boolean bl6 = false;
            PermissionDto it = (PermissionDto)element$iv$iv;
            boolean bl7 = false;
            if (it.getGrantee().getId().toProfileId() == null) continue;
            boolean bl8 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set currentProfileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Iterable $this$mapNotNull$iv4 = currentPermissions;
        boolean $i$f$mapNotNull4 = false;
        destination$iv$iv3 = $this$mapNotNull$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo4 = false;
        void $this$forEach$iv$iv$iv4 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach4 = false;
        Iterator element$iv$iv$iv4 = $this$forEach$iv$iv$iv4.iterator();
        while (element$iv$iv$iv4.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv5;
            Object element$iv$iv = element$iv$iv$iv5 = element$iv$iv$iv4.next();
            boolean bl9 = false;
            PermissionDto it = (PermissionDto)element$iv$iv;
            boolean bl10 = false;
            if (it.getGrantee().getId().toUserGroupId() == null) continue;
            boolean bl11 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        Set currentUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        Set addedProfiles = SetsKt.minus((Set)newProfiles, (Iterable)currentProfileIds);
        Set addedUserGroups = SetsKt.minus((Set)newUserGroups, (Iterable)currentUserGroups);
        if (!((Collection)addedProfiles).isEmpty()) {
            this.authorizationService.checkReadProfiles(addedProfiles, authContext.getUser());
            Iterable $this$forEach$iv = addedProfiles;
            boolean $i$f$forEach5 = false;
            for (Iterable element$iv2 : $this$forEach$iv) {
                ProfileId it = (ProfileId)element$iv2;
                boolean bl12 = false;
                this.authorizationService.checkIfProfileMayReadTenant(wikiToUpdate.getTenantId(), it);
            }
        }
        if (!((Collection)addedUserGroups).isEmpty()) {
            this.authorizationService.checkReadUserGroups(addedUserGroups, authContext.getUser());
        }
        Iterable $this$groupBy$iv = newPermissions;
        boolean $i$f$groupBy = false;
        element$iv2 = $this$groupBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            SetPermissionItemInput it2 = (SetPermissionItemInput)element$iv$iv;
            boolean $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$32 = false;
            PermissionType key$iv$iv = PermissionType.valueOf((String)it2.getType().name());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl13 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            SetPermissionItemInput $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$32 = (SetPermissionItemInput)element$iv$iv;
            List list = list$iv$iv;
            boolean bl14 = false;
            list.add(it.getGranteeId());
        }
        Map permissionMap = destination$iv$iv5;
        return this.permissionService.setPermissions(wikiId, permissionMap);
    }

    @NotNull
    public Map<WikiId, List<PermissionDto>> getPermissionsForWikis(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set wikiSet = CollectionsKt.toSet((Iterable)wikiIds);
        authContext.checkManageWikis(wikiSet);
        return this.permissionService.getPermissionsByWikiIds(wikiSet);
    }
}

