/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.graphql.generated.CreateChapterInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateChapterInput;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J0\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010 \u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "maxPageSize", "", "(Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;I)V", "countChaptersForWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "create", "Lde/justsoftware/wikiservice/business/model/ChapterDto;", "chapterInput", "Lde/justsoftware/wikiservice/graphql/generated/CreateChapterInput;", "delete", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "getAllChildChapters", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "read", "readSubscribedChapters", "page", "size", "update", "input", "Lde/justsoftware/wikiservice/graphql/generated/UpdateChapterInput;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nChapterApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChapterApplicationService.kt\nde/justsoftware/wikiservice/application/ChapterApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1549#3:122\n1620#3,3:123\n766#3:126\n857#3,2:127\n1549#3:129\n1620#3,3:130\n*S KotlinDebug\n*F\n+ 1 ChapterApplicationService.kt\nde/justsoftware/wikiservice/application/ChapterApplicationService\n*L\n43#1:122\n43#1:123,3\n85#1:126\n85#1:127,2\n86#1:129\n86#1:130,3\n*E\n"})
public class ChapterApplicationService {
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;
    private final int maxPageSize;

    @Autowired
    public ChapterApplicationService(@NotNull ChapterService chapterService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService, @Value(value="${service.maxPageSize:200}") int maxPageSize) {
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.chapterService = chapterService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
        this.maxPageSize = maxPageSize;
    }

    @NotNull
    public ChapterDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        ChapterDto chapterDto;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChapterDto it = chapterDto = this.chapterService.read(chapterId);
        boolean bl = false;
        authContext.checkReadWiki(it.getWikiId());
        return chapterDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChapterDto> readSubscribedChapters(int page, int size, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!(page >= 0)) {
            boolean $i$a$-require-ChapterApplicationService$readSubscribedChapters$32 = false;
            String $i$a$-require-ChapterApplicationService$readSubscribedChapters$32 = "Page must not be < 0";
            throw new IllegalArgumentException($i$a$-require-ChapterApplicationService$readSubscribedChapters$32.toString());
        }
        if (!(1 <= size ? size <= this.maxPageSize : false)) {
            boolean $i$a$-require-ChapterApplicationService$readSubscribedChapters$42 = false;
            String $i$a$-require-ChapterApplicationService$readSubscribedChapters$42 = "PageSize must be between 1 and " + this.maxPageSize;
            throw new IllegalArgumentException($i$a$-require-ChapterApplicationService$readSubscribedChapters$42.toString());
        }
        List it = list = this.chapterService.readBySubscriber(authContext.getUser(), page, size);
        boolean bl = false;
        Iterable iterable = it;
        AuthContext authContext2 = authContext;
        boolean $i$f$map = false;
        void var10_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void c;
            ChapterDto chapterDto = (ChapterDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(c.getWikiId());
        }
        authContext2.checkReadWikis(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        return list;
    }

    @Transactional
    @NotNull
    public ChapterDto update(@NotNull ChapterId chapterId, @NotNull UpdateChapterInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId((ParentId)chapterId);
        if (input.getParentId() != null) {
            WikiId toWikiId = this.ancestorService.getAncestorWikiId(input.getParentId());
            authContext.checkMoveWikiContent(wikiId, toWikiId);
        } else {
            authContext.checkWriteWiki(wikiId);
        }
        boolean chapterWasMoved = this.ancestorService.moveChapter(chapterId, input.getParentId(), authContext.getUser());
        return this.chapterService.update(chapterId, input.getTitle(), authContext.getUser(), chapterWasMoved);
    }

    @Transactional
    @NotNull
    public ChapterDto delete(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        ChapterDto chapterDto;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChapterDto chapterDto2 = chapterDto = this.chapterService.read(chapterId);
        boolean bl = false;
        authContext.checkWriteWiki(chapterDto2.getWikiId());
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)chapterId), (ProfileId)authContext.getUser(), null, (int)4, null);
        this.chapterService.delete(chapterId, deletionId, authContext.getUser());
        return chapterDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ChapterDto>> getAllChildChapters(@NotNull List<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List chapters;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Map map;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map parentIdsToChildChapters = map = this.chapterService.readByParentIds(CollectionsKt.toSet((Iterable)parentIds));
        boolean bl = false;
        Iterable iterable = parentIdsToChildChapters.values();
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            chapters = (List)element$iv$iv;
            boolean bl2 = false;
            boolean bl3 = !((Collection)chapters).isEmpty();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            chapters = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(((ChapterDto)CollectionsKt.first((List)chapters)).getWikiId());
        }
        Set parentWikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadWikis(parentWikiIds);
        return map;
    }

    @NotNull
    public Map<WikiId, Integer> countChaptersForWikis(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            authContext.checkReadWikis(CollectionsKt.toSet((Iterable)wikiIds));
            map = this.chapterService.countByWikiIds(CollectionsKt.toSet((Iterable)wikiIds));
        }
        return map;
    }

    @NotNull
    public ChapterDto create(@NotNull CreateChapterInput chapterInput, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterInput, (String)"chapterInput");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = chapterInput.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        this.ancestorService.checkMaxNestingDepthOfNewChapter(parentId);
        return this.chapterService.create(wikiId, parentId, chapterInput.getTitle(), authContext.getUser(), position);
    }
}

