/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.controller;

import de.justsoftware.search.business.SolrIndexService;
import de.justsoftware.search.business.SuperopertyConnector;
import de.justsoftware.search.shared.model.JustSocialSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Hidden
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017J\u0018\u0010\u000e\u001a\u00020\n2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0017J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\nH\u0017J\u0012\u0010\u0013\u001a\u00020\n2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/search/controller/InternalController;", "", "justVersion", "", "superopertyConnector", "Lde/justsoftware/search/business/SuperopertyConnector;", "solrIndexService", "Lde/justsoftware/search/business/SolrIndexService;", "(Ljava/lang/String;Lde/justsoftware/search/business/SuperopertyConnector;Lde/justsoftware/search/business/SolrIndexService;)V", "deleteSolrDocuments", "", "ids", "", "Lde/justsoftware/search/shared/model/SearchableId;", "indexSolrDocuments", "docs", "Lde/justsoftware/search/shared/model/JustSocialSolrDocument;", "nextSearchEnabled", "", "reindex", "type", "Lde/justsoftware/search/shared/model/SearchType;", "search-service"})
public class InternalController {
    @NotNull
    private final String justVersion;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final SolrIndexService solrIndexService;

    public InternalController(@Value(value="${just.version}") @NotNull String justVersion, @NotNull SuperopertyConnector superopertyConnector, @NotNull SolrIndexService solrIndexService) {
        Intrinsics.checkNotNullParameter((Object)justVersion, (String)"justVersion");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)solrIndexService, (String)"solrIndexService");
        this.justVersion = justVersion;
        this.superopertyConnector = superopertyConnector;
        this.solrIndexService = solrIndexService;
    }

    @GetMapping(value={"version"})
    @NotNull
    public String justVersion() {
        return this.justVersion;
    }

    @GetMapping(value={"nextSearchEnabled"})
    public boolean nextSearchEnabled() {
        return this.superopertyConnector.getNextSearchEnabled();
    }

    @PostMapping(value={"deleteSolrDocuments"})
    public void deleteSolrDocuments(@RequestBody @NotNull List<SearchableId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.solrIndexService.deleteSolrDocuments(ids);
    }

    @PostMapping(value={"indexSolrDocuments"})
    public void indexSolrDocuments(@RequestBody @NotNull List<? extends JustSocialSolrDocument> docs) {
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        this.solrIndexService.indexSolrDocuments(docs);
    }

    @GetMapping(value={"reindexAll"})
    public void reindex() {
        this.solrIndexService.reindexAll();
    }

    @GetMapping(value={"reindex/{type}"})
    public void reindex(@PathVariable(value="type") @NotNull SearchType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.solrIndexService.reindex(type);
    }
}

