/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.rest;

import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.maintenance.MaintenanceService;
import de.justsoftware.news.domain.migration.MentionMigrationService;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.rest.InternalRepublishService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0013J\b\u0010\u000e\u001a\u00020\rH\u0013J\b\u0010\u000f\u001a\u00020\rH\u0013J\u0012\u0010\u0010\u001a\u00020\r2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0013J\b\u0010\u0013\u001a\u00020\rH\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/news/rest/InternalController;", "", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "internalRepublishService", "Lde/justsoftware/news/rest/InternalRepublishService;", "maintenanceService", "Lde/justsoftware/news/domain/maintenance/MaintenanceService;", "mentionMigrationService", "Lde/justsoftware/news/domain/migration/MentionMigrationService;", "<init>", "(Lde/justsoftware/news/domain/delete/DeleteService;Lde/justsoftware/news/rest/InternalRepublishService;Lde/justsoftware/news/domain/maintenance/MaintenanceService;Lde/justsoftware/news/domain/migration/MentionMigrationService;)V", "deleteChannelsAndPosts", "", "republishPermissions", "reIndexSearchForAllTenants", "reIndexSearchForTenant", "tenantId", "", "startMentionMigration", "news-service"})
public class InternalController {
    @NotNull
    private final DeleteService deleteService;
    @NotNull
    private final InternalRepublishService internalRepublishService;
    @NotNull
    private final MaintenanceService maintenanceService;
    @NotNull
    private final MentionMigrationService mentionMigrationService;

    public InternalController(@NotNull DeleteService deleteService, @NotNull InternalRepublishService internalRepublishService, @NotNull MaintenanceService maintenanceService, @NotNull MentionMigrationService mentionMigrationService) {
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        Intrinsics.checkNotNullParameter((Object)internalRepublishService, (String)"internalRepublishService");
        Intrinsics.checkNotNullParameter((Object)maintenanceService, (String)"maintenanceService");
        Intrinsics.checkNotNullParameter((Object)mentionMigrationService, (String)"mentionMigrationService");
        this.deleteService = deleteService;
        this.internalRepublishService = internalRepublishService;
        this.maintenanceService = maintenanceService;
        this.mentionMigrationService = mentionMigrationService;
    }

    @PostMapping(value={"/delete/channels-and-posts"})
    @ResponseStatus(value=HttpStatus.OK)
    private void deleteChannelsAndPosts() {
        this.deleteService.delete();
    }

    @PostMapping(value={"/republish/permissions"})
    @ResponseStatus(value=HttpStatus.OK)
    private void republishPermissions() {
        this.internalRepublishService.republishAll();
    }

    @PostMapping(value={"/search/reindex"})
    @ResponseStatus(value=HttpStatus.OK)
    private void reIndexSearchForAllTenants() {
        this.maintenanceService.reIndexSearchForAllTenants();
    }

    @PostMapping(value={"/search/reindex/tenants/{tenantId}"})
    @ResponseStatus(value=HttpStatus.OK)
    private void reIndexSearchForTenant(@PathVariable String tenantId) {
        this.maintenanceService.reIndexSearchForTenant(TenantId.Companion.fromString(tenantId));
    }

    @PostMapping(value={"/mention/migration"})
    @ResponseStatus(value=HttpStatus.OK)
    private void startMentionMigration() {
        this.mentionMigrationService.migrateQuillMentions();
    }
}

