/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.search;

import de.justsoftware.news.id.SearchableItemId;
import de.justsoftware.news.kafka.KafkaConsumerConfiguration;
import de.justsoftware.news.kafka.search.KafkaSearchConsumerConfiguration;
import de.justsoftware.news.kafka.search.SearchIndexType;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

@Configuration
@EnableKafka
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007H\u0017J\u0016\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/news/kafka/search/KafkaSearchConsumerConfiguration;", "", "kafkaConsumerConfiguration", "Lde/justsoftware/news/kafka/KafkaConsumerConfiguration;", "<init>", "(Lde/justsoftware/news/kafka/KafkaConsumerConfiguration;)V", "searchIndexListenerContainerFactory", "Lorg/springframework/kafka/config/KafkaListenerContainerFactory;", "Lorg/springframework/kafka/listener/ConcurrentMessageListenerContainer;", "Lde/justsoftware/news/id/SearchableItemId;", "Lde/justsoftware/news/kafka/search/SearchIndexType;", "consumerConfig", "", "", "SearcheableIdDeserializer", "SearchIndexTypeDeserializer", "news-service"})
public class KafkaSearchConsumerConfiguration {
    @NotNull
    private final KafkaConsumerConfiguration kafkaConsumerConfiguration;

    public KafkaSearchConsumerConfiguration(@NotNull KafkaConsumerConfiguration kafkaConsumerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerConfiguration, (String)"kafkaConsumerConfiguration");
        this.kafkaConsumerConfiguration = kafkaConsumerConfiguration;
    }

    @Bean
    @NotNull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<SearchableItemId, SearchIndexType>> searchIndexListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(this.consumerConfig()));
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
        exponentialBackOff.setMaxElapsedTime(Duration.ofDays(1L).toMillis());
        factory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)exponentialBackOff));
        factory.setBatchListener(Boolean.valueOf(true));
        return (KafkaListenerContainerFactory)factory;
    }

    private Map<String, Object> consumerConfig() {
        Map props = this.kafkaConsumerConfiguration.defaultConsumerConfig();
        props.put("spring.deserializer.key.delegate.class", SearcheableIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", SearchIndexTypeDeserializer.class);
        props.put("max.poll.records", 100);
        props.put("fetch.max.wait.ms", 500);
        props.put("fetch.min.bytes", Integer.MAX_VALUE);
        return props;
    }
}

