/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post.unreadmark;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.post.unreadmark.PostUnreadMarkRepo;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.domain.user.ProfileStatus;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostReadEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.PostUnreadMarkId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Unauthorized;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkService;", "", "postUnreadMarkRepo", "Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkRepo;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lorg/springframework/context/ApplicationEventPublisher;)V", "getNumberOfUnreadPosts", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "markPostAsRead", "", "postId", "Lde/justsoftware/news/id/PostId;", "markAllPostsAsRead", "markPostAsUnread", "event", "Lde/justsoftware/news/events/PostPublishedEvent;", "cleanUpOldEntries", "deletionDelay", "Ljava/time/Duration;", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostUnreadMarkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostUnreadMarkService.kt\nde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1557#2:70\n1628#2,3:71\n1557#2:74\n1628#2,3:75\n1863#2,2:78\n*S KotlinDebug\n*F\n+ 1 PostUnreadMarkService.kt\nde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkService\n*L\n45#1:70\n45#1:71,3\n49#1:74\n49#1:75,3\n51#1:78,2\n*E\n"})
public class PostUnreadMarkService {
    @NotNull
    private final PostUnreadMarkRepo postUnreadMarkRepo;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public PostUnreadMarkService(@NotNull PostUnreadMarkRepo postUnreadMarkRepo, @NotNull ProfileRepo profileRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)postUnreadMarkRepo, (String)"postUnreadMarkRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.postUnreadMarkRepo = postUnreadMarkRepo;
        this.profileRepo = profileRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.eventPublisher = eventPublisher;
    }

    public int getNumberOfUnreadPosts(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.postUnreadMarkRepo.countByProfileId(authContext.getUser());
    }

    public void markPostAsRead(@NotNull PostId postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.postUnreadMarkRepo.deleteByPostIdAndProfileId(postId, authContext.getUser());
        this.eventPublisher.publishEvent((ApplicationEvent)new PostReadEvent(postId, authContext.getUser()));
    }

    public void markAllPostsAsRead(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.postUnreadMarkRepo.deleteByProfileId(authContext.getUser());
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener
    public void markPostAsUnread(@NotNull PostPublishedEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$map$iv2 = SubscriptionRepoWrapper.getSubscribers$default((SubscriptionRepoWrapper)this.subscriptionRepoWrapper, (ChannelId)event.getPost().getChannelId(), null, null, null, (int)14, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Profile profile = (Profile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List subscriberIds = (List)destination$iv$iv;
        Object $i$f$map22 = new ProfileStatus[]{ProfileStatus.ACTIVE, ProfileStatus.BLOCKED};
        $i$f$map22 = this.profileRepo.getIdsAndStatusIn((Collection)subscriberIds, SetsKt.setOf((Object[])$i$f$map22));
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Profile bl = (Profile)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        List profileIds = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)profileIds, (Object)event.getPost().getAuthorId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProfileId it = (ProfileId)element$iv;
            boolean bl = false;
            this.postUnreadMarkRepo.insert(PostUnreadMarkId.Companion.random(), event.getPost().getId(), it, event.getPost().getPublishDate());
        }
    }

    @Unauthorized
    public void cleanUpOldEntries(@NotNull Duration deletionDelay) {
        Intrinsics.checkNotNullParameter((Object)deletionDelay, (String)"deletionDelay");
        Instant instant = Instant.now().minus(deletionDelay.toSeconds(), ChronoUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
        this.postUnreadMarkRepo.deleteByPostPublishedDateLessThan(instant);
    }
}

