/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsService;
import de.justsoftware.news.id.PostId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.MappedBatchLoaderWithContext;
import org.jetbrains.annotations.NotNull;

@DgsDataLoader(name="commentNotificationsEnabledByPostIds")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0013\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/news/domain/post/CommentNotificationsEnabledBatchLoader;", "Lorg/dataloader/MappedBatchLoaderWithContext;", "Lde/justsoftware/news/id/PostId;", "", "commentNotificationsService", "Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsService;", "<init>", "(Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsService;)V", "load", "Ljava/util/concurrent/CompletionStage;", "", "postIds", "", "ble", "Lorg/dataloader/BatchLoaderEnvironment;", "news-service"})
class CommentNotificationsEnabledBatchLoader
implements MappedBatchLoaderWithContext<PostId, Boolean> {
    @NotNull
    private final CommentNotificationsService commentNotificationsService;

    public CommentNotificationsEnabledBatchLoader(@NotNull CommentNotificationsService commentNotificationsService) {
        Intrinsics.checkNotNullParameter((Object)commentNotificationsService, (String)"commentNotificationsService");
        this.commentNotificationsService = commentNotificationsService;
    }

    @NotNull
    public CompletionStage<Map<PostId, Boolean>> load(@NotNull Set<PostId> postIds, @NotNull BatchLoaderEnvironment ble) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Intrinsics.checkNotNullParameter((Object)ble, (String)"ble");
        CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> CommentNotificationsEnabledBatchLoader.load$lambda$0(ble, this, postIds));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final Map load$lambda$0(BatchLoaderEnvironment $ble, CommentNotificationsEnabledBatchLoader this$0, Set $postIds) {
        Intrinsics.checkNotNullParameter((Object)$ble, (String)"$ble");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$postIds, (String)"$postIds");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext($ble);
        return this$0.commentNotificationsService.getHasNotificationsEnabled(authContext.getUser(), (Collection)$postIds);
    }
}

