/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.migration.InsertNewMention;
import de.justsoftware.news.domain.migration.MentionMigrationService;
import de.justsoftware.news.domain.migration.NewMention;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.UserId;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/news/domain/migration/MentionMigrationService;", "", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "<init>", "(Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;)V", "value", "", "hasError", "getHasError", "()Z", "migrateQuillMentions", "", "updatePostJsonContent", "post", "Lde/justsoftware/news/domain/post/Post;", "updateCommentJsonContent", "comment", "Lde/justsoftware/news/domain/comment/PostComment;", "convertQuillMention", "jsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nMentionMigrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MentionMigrationService.kt\nde/justsoftware/news/domain/migration/MentionMigrationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1863#2,2:123\n*S KotlinDebug\n*F\n+ 1 MentionMigrationService.kt\nde/justsoftware/news/domain/migration/MentionMigrationService\n*L\n79#1:123,2\n*E\n"})
public class MentionMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    private boolean hasError;
    @NotNull
    private static final String MENTION_PREFIX = "@";
    @NotNull
    private static final Logger log;

    public MentionMigrationService(@NotNull PostRepo postRepo, @NotNull PostCommentRepo postCommentRepo) {
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        this.postRepo = postRepo;
        this.postCommentRepo = postCommentRepo;
    }

    public final boolean getHasError() {
        return this.hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateQuillMentions() {
        Stream it2;
        log.info("Starting mention migration.");
        AutoCloseable autoCloseable = this.postRepo.findWithLegacyMentions();
        Throwable throwable = null;
        try {
            it2 = (Stream)autoCloseable;
            boolean bl = false;
            it2.forEach(arg_0 -> MentionMigrationService.migrateQuillMentions$lambda$2$lambda$1(arg_0 -> MentionMigrationService.migrateQuillMentions$lambda$2$lambda$0(this, arg_0), arg_0));
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        log.info("Post mention migration completed.");
        autoCloseable = this.postCommentRepo.findWithLegacyMentions();
        throwable = null;
        try {
            it2 = (Stream)autoCloseable;
            boolean bl = false;
            it2.forEach(arg_0 -> MentionMigrationService.migrateQuillMentions$lambda$5$lambda$4(arg_0 -> MentionMigrationService.migrateQuillMentions$lambda$5$lambda$3(this, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        log.info("Mention migration completed.");
    }

    private void updatePostJsonContent(Post post) {
        JsonNode jsonNode = ExtensionsKt.jacksonObjectMapper().readTree(post.getJsonContent());
        if (jsonNode.get("ops") == null) {
            return;
        }
        try {
            Intrinsics.checkNotNull((Object)jsonNode);
            if (this.convertQuillMention(jsonNode)) {
                log.info("Migrating post " + post.getId().toTypedString());
                PostId postId = post.getId();
                String string = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)jsonNode);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                this.postRepo.updateJsonContent(postId, string);
            }
        }
        catch (Exception exception) {
            this.hasError = true;
            log.error("Error migrating mentions for " + post.getId(), (Throwable)exception);
        }
    }

    private void updateCommentJsonContent(PostComment comment) {
        JsonNode jsonNode = ExtensionsKt.jacksonObjectMapper().readTree(comment.getJsonContent());
        if (jsonNode.get("ops") == null) {
            return;
        }
        try {
            Intrinsics.checkNotNull((Object)jsonNode);
            if (this.convertQuillMention(jsonNode)) {
                log.info("Migrating comment " + comment.getId().toTypedString());
                CommentId commentId = comment.getId();
                String string = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)jsonNode);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                this.postCommentRepo.updateJsonContent(commentId, string);
            }
        }
        catch (Exception exception) {
            this.hasError = true;
            log.error("Error migrating mentions for " + comment.getId(), (Throwable)exception);
        }
    }

    private boolean convertQuillMention(JsonNode jsonNode) {
        boolean jsonUpdated = false;
        JsonNode jsonNode2 = jsonNode.get("ops");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"get(...)");
        Iterable $this$forEach$iv = (Iterable)jsonNode2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            JsonNode mention;
            JsonNode attributes;
            JsonNode rootNode = (JsonNode)element$iv;
            boolean bl = false;
            if (rootNode.get("attributes") == null || attributes.get("mention") == null) continue;
            String insert = rootNode.get("insert").asText();
            Intrinsics.checkNotNull((Object)rootNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode objectNode = (ObjectNode)rootNode;
            String string2 = mention.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
            UserId userId = UserId.Companion.fromString(string2);
            log.info("Migrating mention: " + insert);
            objectNode.remove("attributes");
            objectNode.remove("insert");
            String string3 = userId.toTypedString();
            String string4 = "#/!profile." + userId.getValue();
            Intrinsics.checkNotNull((Object)insert);
            if (StringsKt.startsWith$default((String)insert, (String)MENTION_PREFIX, (boolean)false, (int)2, null)) {
                String string5 = insert.substring(1);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string = insert;
            }
            String string6 = string;
            Intrinsics.checkNotNull((Object)string6);
            InsertNewMention newMention = new InsertNewMention(new NewMention("0", MENTION_PREFIX, string3, string4, string6));
            JsonNode migratedJsonNode = ExtensionsKt.jacksonObjectMapper().valueToTree((Object)newMention);
            objectNode.putIfAbsent("insert", migratedJsonNode);
            log.info("Original json_content: " + rootNode);
            jsonUpdated = true;
        }
        return jsonUpdated;
    }

    private static final Unit migrateQuillMentions$lambda$2$lambda$0(MentionMigrationService this$0, Post it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        this$0.updatePostJsonContent(it);
        return Unit.INSTANCE;
    }

    private static final void migrateQuillMentions$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit migrateQuillMentions$lambda$5$lambda$3(MentionMigrationService this$0, PostComment it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        this$0.updateCommentJsonContent(it);
        return Unit.INSTANCE;
    }

    private static final void migrateQuillMentions$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MentionMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

