/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.event;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.event.EventService;
import de.justsoftware.news.graphql.generated.types.Event;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/domain/event/EventDataFetcher;", "", "eventService", "Lde/justsoftware/news/domain/event/EventService;", "<init>", "(Lde/justsoftware/news/domain/event/EventService;)V", "icsExportFileUrl", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "icsExportString", "news-service"})
public class EventDataFetcher {
    @NotNull
    private final EventService eventService;

    public EventDataFetcher(@NotNull EventService eventService) {
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        this.eventService = eventService;
    }

    @DgsData(parentType="Event", field="icsExportFileUrl")
    @NotNull
    public String icsExportFileUrl(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String eventId = ((Event)dfe.getSource()).getId().toTypedString();
        return "/news/rest/event/" + eventId + "/ics-export";
    }

    @DgsData(parentType="Event", field="icsExportString")
    @NotNull
    public String icsExportString(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.eventService.exportIcs(((Event)dfe.getSource()).getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }
}

