/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.controller;

import de.justsoftware.mobile.gateway.wiki.model.SubscribedWikiItem;
import de.justsoftware.mobile.gateway.wiki.model.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticleTranslation;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticleTranslationCandidate;
import de.justsoftware.mobile.gateway.wiki.model.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.WikiTeaser;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wiki"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u0011H\u0017J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u0011H\u0017J&\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001a\u001a\u00020\u00112\b\b\u0001\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/mobile/gateway/wiki/controller/WikiController;", "", "wikiService", "Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "<init>", "(Lde/justsoftware/mobile/gateway/wiki/service/WikiService;)V", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/model/WikiTeaser;", "offset", "", "limit", "getSubscribedWikiItems", "Lde/justsoftware/mobile/gateway/wiki/model/SubscribedWikiItem;", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/Wiki;", "wikiId", "", "subscribe", "Lde/justsoftware/mobile/gateway/wiki/model/Subscription;", "unsubscribe", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/WikiChapter;", "chapterId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticle;", "articleId", "translateWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticleTranslation;", "targetLanguage", "candidate", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticleTranslationCandidate;", "mobile-gateway"})
public class WikiController {
    @NotNull
    private final WikiService wikiService;

    public WikiController(@NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.wikiService = wikiService;
    }

    @GetMapping(value={"/teasers"})
    @NotNull
    public List<WikiTeaser> getWikiTeasers(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit) {
        return this.wikiService.getWikiTeasers(offset, limit);
    }

    @GetMapping(value={"/subscribedItems"})
    @NotNull
    public List<SubscribedWikiItem> getSubscribedWikiItems(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit) {
        return this.wikiService.getSubscribedWikiItems(offset, limit);
    }

    @GetMapping(value={"/{id}"})
    @Nullable
    public Wiki getWiki(@PathVariable(value="id") @NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return this.wikiService.getWiki(wikiId);
    }

    @PostMapping(value={"/{id}/subscribe"})
    @Nullable
    public Subscription subscribe(@PathVariable(value="id") @NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return this.wikiService.subscribe(wikiId);
    }

    @PostMapping(value={"/{id}/unsubscribe"})
    @Nullable
    public Subscription unsubscribe(@PathVariable(value="id") @NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return this.wikiService.unsubscribe(wikiId);
    }

    @GetMapping(value={"/chapter/{id}"})
    @Nullable
    public WikiChapter getWikiChapter(@PathVariable(value="id") @NotNull String chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        return this.wikiService.getWikiChapter(chapterId);
    }

    @GetMapping(value={"/article/{id}"})
    @Nullable
    public WikiArticle getWikiArticle(@PathVariable(value="id") @NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        return this.wikiService.getWikiArticle(articleId);
    }

    @PutMapping(value={"/article/{id}/translate/{targetLanguage}"})
    @NotNull
    public WikiArticleTranslation translateWikiArticle(@PathVariable(value="id") @NotNull String articleId, @PathVariable(value="targetLanguage") @NotNull String targetLanguage, @RequestBody @NotNull WikiArticleTranslationCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return this.wikiService.translateWikiArticle(articleId, targetLanguage, candidate);
    }
}

