/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.exception.ForbiddenException;
import de.justsoftware.mobile.gateway.people.model.local.BirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileConfiguration;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfilePersonalData;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UpdateBirthdayData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileDetailsData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileSectionData;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.service.LegacyMobilePeopleApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J \u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00152\u0006\u0010/\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J \u00102\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000fH\u0016J\u0010\u00108\u001a\u0002062\u0006\u00107\u001a\u00020\u000fH\u0016J6\u00109\u001a\u0002H:\"\u0004\b\u0000\u0010:2!\u0010;\u001a\u001d\u0012\u0013\u0012\u00110=\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(@\u0012\u0004\u0012\u0002H:0<H\u0012\u00a2\u0006\u0002\u0010AR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "", "mobilePeopleApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/LegacyMobilePeopleApiGatewayService;", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "peopleApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "profileApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/people/service/LegacyMobilePeopleApiGatewayService;Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;)V", "getProfileDetails", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "userId", "", "currentUserId", "updateProfileDetails", "updateProfileDetailsData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileDetailsData;", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "getAttributes", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "updateAttribute", "updateAttributeData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileSectionData;", "deleteAttributes", "sectionKey", "getConfiguration", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileConfiguration;", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/local/BirthdayProfile;", "currentDate", "getProfilePersonalData", "Lde/justsoftware/mobile/gateway/people/model/local/ProfilePersonalData;", "updateBirthday", "updateBirthdayData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateBirthdayData;", "enableBirthdayReminderForProfile", "", "profileId", "disableBirthdayReminderForProfile", "withChatEnabled", "T", "block", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "chatEnabled", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,307:1\n1557#2:308\n1628#2,3:309\n1557#2:312\n1628#2,3:313\n1557#2:316\n1628#2,3:317\n*S KotlinDebug\n*F\n+ 1 PeopleService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleService\n*L\n87#1:308\n87#1:309,3\n102#1:312\n102#1:313,3\n122#1:316\n122#1:317,3\n*E\n"})
public class PeopleService {
    @NotNull
    private final LegacyMobilePeopleApiGatewayService mobilePeopleApiGatewayService;
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;
    @NotNull
    private final PeopleApiGatewayService peopleApiGatewayService;
    @NotNull
    private final LegacyProfileApiGatewayService profileApiGatewayService;

    public PeopleService(@NotNull LegacyMobilePeopleApiGatewayService mobilePeopleApiGatewayService, @NotNull ToroApiGatewayService toroApiGatewayService, @NotNull PeopleApiGatewayService peopleApiGatewayService, @NotNull LegacyProfileApiGatewayService profileApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)mobilePeopleApiGatewayService, (String)"mobilePeopleApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)peopleApiGatewayService, (String)"peopleApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)profileApiGatewayService, (String)"profileApiGatewayService");
        this.mobilePeopleApiGatewayService = mobilePeopleApiGatewayService;
        this.toroApiGatewayService = toroApiGatewayService;
        this.peopleApiGatewayService = peopleApiGatewayService;
        this.profileApiGatewayService = profileApiGatewayService;
    }

    @NotNull
    public ProfileDetails getProfileDetails(@NotNull String userId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return (ProfileDetails)this.withChatEnabled(arg_0 -> PeopleService.getProfileDetails$lambda$0(this, userId, currentUserId, arg_0));
    }

    @NotNull
    public ProfileDetails updateProfileDetails(@NotNull String userId, @NotNull UpdateProfileDetailsData updateProfileDetailsData, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateProfileDetailsData, (String)"updateProfileDetailsData");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return (ProfileDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Profile> getProfiles(@Nullable String query, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.peopleApiGatewayService.getProfiles(query, offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiProfile;
            PeopleApiProfile peopleApiProfile = (PeopleApiProfile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Profile.Companion.toProfile((PeopleApiProfile)apiProfile));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UserGroup> getUserGroups(@Nullable String query, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.peopleApiGatewayService.getUserGroups(query, offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiUserGroup;
            PeopleApiUserGroup peopleApiUserGroup = (PeopleApiUserGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UserGroup.Companion.toUserGroup((PeopleApiUserGroup)apiUserGroup));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public UserGroup getUserGroup(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return UserGroup.Companion.toUserGroup(this.peopleApiGatewayService.getUserGroup(groupId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Profile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Iterable iterable = this.peopleApiGatewayService.getUserGroupMembers(groupId, offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiProfile;
            PeopleApiProfile peopleApiProfile = (PeopleApiProfile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Profile.Companion.toProfile((PeopleApiProfile)apiProfile));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ProfileDetails updateUserImage(@NotNull String userId, @NotNull MultipartFile image, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return (ProfileDetails)this.withChatEnabled(arg_0 -> PeopleService.updateUserImage$lambda$4(this, userId, currentUserId, image, arg_0));
    }

    @NotNull
    public ProfileDetails deleteUserImage(@NotNull String userId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return (ProfileDetails)this.withChatEnabled(arg_0 -> PeopleService.deleteUserImage$lambda$5(this, userId, currentUserId, arg_0));
    }

    @NotNull
    public List<ProfileSection> getAttributes(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return ProfileSection.Companion.toProfileSections(this.profileApiGatewayService.getProfileAttributes(userId));
    }

    @NotNull
    public List<ProfileSection> updateAttribute(@NotNull String userId, @NotNull UpdateProfileSectionData updateAttributeData) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateAttributeData, (String)"updateAttributeData");
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public List<ProfileSection> deleteAttributes(@NotNull String userId, @NotNull String sectionKey) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sectionKey, (String)"sectionKey");
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public ProfileConfiguration getConfiguration(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (ProfileConfiguration)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public List<BirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        return BirthdayProfile.Companion.toBirthdayProfiles(this.peopleApiGatewayService.getBirthdayProfiles(currentDate, offset, limit));
    }

    private ProfilePersonalData getProfilePersonalData(String userId, String currentUserId) {
        ProfilePersonalData profilePersonalData;
        if (!Intrinsics.areEqual((Object)userId, (Object)currentUserId)) {
            profilePersonalData = null;
        } else {
            PeopleService peopleService;
            Object $this$getProfilePersonalData_u24lambda_u246;
            PeopleService peopleService2 = this;
            try {
                $this$getProfilePersonalData_u24lambda_u246 = peopleService2;
                boolean bl = false;
                $this$getProfilePersonalData_u24lambda_u246 = Result.constructor-impl((Object)ProfilePersonalData.Companion.toProfilePersonalData($this$getProfilePersonalData_u24lambda_u246.profileApiGatewayService.getPersonalData(userId)));
            }
            catch (Throwable bl) {
                $this$getProfilePersonalData_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            peopleService2 = $this$getProfilePersonalData_u24lambda_u246;
            Throwable throwable = Result.exceptionOrNull-impl((Object)peopleService2);
            if (throwable == null) {
                peopleService = peopleService2;
            } else {
                Throwable error = throwable;
                boolean bl = false;
                if (error instanceof ForbiddenException) {
                    peopleService = null;
                } else {
                    throw error;
                }
            }
            profilePersonalData = (ProfilePersonalData)peopleService;
        }
        return profilePersonalData;
    }

    @NotNull
    public ProfileDetails updateBirthday(@NotNull String userId, @NotNull UpdateBirthdayData updateBirthdayData, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateBirthdayData, (String)"updateBirthdayData");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return (ProfileDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    public void enableBirthdayReminderForProfile(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.peopleApiGatewayService.enableBirthdayReminderForProfile(profileId);
    }

    public void disableBirthdayReminderForProfile(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.peopleApiGatewayService.disableBirthdayReminderForProfile(profileId);
    }

    private <T> T withChatEnabled(Function1<? super Boolean, ? extends T> block) {
        return (T)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private static final ProfileDetails getProfileDetails$lambda$0(PeopleService this$0, String $userId, String $currentUserId, boolean chatEnabled) {
        ProfilePersonalData personalData = this$0.getProfilePersonalData($userId, $currentUserId);
        return ProfileDetails.Companion.toProfileDetails(this$0.profileApiGatewayService.getProfile($userId), $currentUserId, chatEnabled, personalData);
    }

    private static final ProfileDetails updateUserImage$lambda$4(PeopleService this$0, String $userId, String $currentUserId, MultipartFile $image, boolean chatEnabled) {
        ProfilePersonalData personalData = this$0.getProfilePersonalData($userId, $currentUserId);
        return ProfileDetails.Companion.toProfileDetails(this$0.profileApiGatewayService.updateUserImage($userId, $image), $currentUserId, chatEnabled, personalData);
    }

    private static final ProfileDetails deleteUserImage$lambda$5(PeopleService this$0, String $userId, String $currentUserId, boolean chatEnabled) {
        ProfilePersonalData personalData = this$0.getProfilePersonalData($userId, $currentUserId);
        return ProfileDetails.Companion.toProfileDetails(this$0.profileApiGatewayService.deleteUserImage($userId), $currentUserId, chatEnabled, personalData);
    }

    public static final /* synthetic */ LegacyMobilePeopleApiGatewayService access$getMobilePeopleApiGatewayService$p(PeopleService $this) {
        return $this.mobilePeopleApiGatewayService;
    }

    public static final /* synthetic */ LegacyProfileApiGatewayService access$getProfileApiGatewayService$p(PeopleService $this) {
        return $this.profileApiGatewayService;
    }

    public static final /* synthetic */ ToroApiGatewayService access$getToroApiGatewayService$p(PeopleService $this) {
        return $this.toroApiGatewayService;
    }
}

