/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiBirthdayList;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiBirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiConfig;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfileSearchResults;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfiles;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroups;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$disableBirthdayReminderForProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$enableBirthdayReminderForProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getUserGroup$;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\"\u0010\u001f\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\"\u0010 \u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0003H\u0012J \u0010\"\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J \u0010#\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "", "peopleApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "configUri", "Ljava/net/URI;", "getConfig", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiConfig;", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiProfile;", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiUserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiBirthdayProfile;", "currentDate", "enableBirthdayReminderForProfile", "", "profileId", "disableBirthdayReminderForProfile", "profilesUri", "userGroupsUri", "userGroupDetailsUri", "userGroupMembersUri", "birthdayProfileUri", "updateBirthdayReminderForProfileUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,146:1\n28#2:147\n28#2:148\n28#2:149\n28#2:150\n28#2:151\n28#2:152\n34#2:153\n65#2:154\n*S KotlinDebug\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n*L\n29#1:147\n37#1:148\n52#1:149\n63#1:150\n72#1:151\n87#1:152\n91#1:153\n94#1:154\n*E\n"})
public class PeopleApiGatewayService {
    @NotNull
    private final String peopleApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI configUri;

    public PeopleApiGatewayService(@Value(value="${just.people.api.url}") @NotNull String peopleApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)peopleApiUrl, (String)"peopleApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.peopleApiUrl = peopleApiUrl;
        this.webClient = webClient;
        this.configUri = UrisKt.buildUri$default((String)(this.peopleApiUrl + "/config"), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiConfig getConfig() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.configUri;
        boolean $i$f$get = false;
        return (PeopleApiConfig)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getProfiles(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.profilesUri(query, offset, limit);
        boolean $i$f$get = false;
        return PeopleApiProfile.Companion.toApiProfiles((PeopleApiProfileSearchResults)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfiles$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiUserGroup> getUserGroups(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupsUri(query, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroups)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiUserGroup getUserGroup(@NotNull String groupId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.userGroupDetailsUri(groupId);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroupDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUserGroup$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null)).getUserGroup();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupMembersUri(groupId, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiBirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        WebClient webClient = this.webClient;
        URI uri$iv = this.birthdayProfileUri(currentDate, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiBirthdayList)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    public void enableBirthdayReminderForProfile(@NotNull String profileId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.updateBirthdayReminderForProfileUri(profileId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new enableBirthdayReminderForProfile$$inlined$post$1((WebClient)$this$post$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void disableBirthdayReminderForProfile(@NotNull String profileId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.updateBirthdayReminderForProfileUri(profileId);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new disableBirthdayReminderForProfile$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    private URI profilesUri(String query, int offset, int limit) {
        Map map;
        Map $this$profilesUri_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$profilesUri_u24lambda_u240.put("offset", offset);
        $this$profilesUri_u24lambda_u240.put("limit", limit);
        if (query != null) {
            $this$profilesUri_u24lambda_u240.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri((String)(this.peopleApiUrl + "/profiles"), (Map)params);
    }

    private URI userGroupsUri(String query, int offset, int limit) {
        Map map;
        Map $this$userGroupsUri_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$userGroupsUri_u24lambda_u241.put("offset", offset);
        $this$userGroupsUri_u24lambda_u241.put("limit", limit);
        if (query != null) {
            $this$userGroupsUri_u24lambda_u241.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri((String)(this.peopleApiUrl + "/usergroups"), (Map)params);
    }

    private URI userGroupDetailsUri(String groupId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups/" + groupId), null, (int)2, null);
    }

    private URI userGroupMembersUri(String groupId, int offset, int limit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"limit", (Object)limit)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri((String)(this.peopleApiUrl + "/usergroups/" + groupId + "/members"), (Map)params);
    }

    private URI birthdayProfileUri(String currentDate, int offset, int limit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"currentDate", (Object)currentDate), TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"limit", (Object)limit)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri((String)(this.peopleApiUrl + "/profiles/birthdayList"), (Map)params);
    }

    private URI updateBirthdayReminderForProfileUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/birthdayList/reminder/" + profileId), null, (int)2, null);
    }
}

