/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import de.justsoftware.mobile.gateway.exception.CommentTooLongException;
import de.justsoftware.mobile.gateway.exception.ForbiddenException;
import de.justsoftware.mobile.gateway.exception.InvalidVersionCodeException;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.exception.PostAlreadyUpdatedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(value={"de.justsoftware.mobile.gateway"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\fH\u0017J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u000eH\u0017J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0010H\u0017J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0013H\u0012\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/MobileGatewayExceptionHandler;", "", "<init>", "()V", "handleNotFoundException", "Lorg/springframework/http/ResponseEntity;", "", "e", "Lde/justsoftware/mobile/gateway/exception/NotFoundException;", "handleForbiddenException", "Lde/justsoftware/mobile/gateway/exception/ForbiddenException;", "handleInvalidVersionCodeException", "Lde/justsoftware/mobile/gateway/exception/InvalidVersionCodeException;", "handlePostAlreadyUpdatedException", "Lde/justsoftware/mobile/gateway/exception/PostAlreadyUpdatedException;", "handleCommentTooLongException", "Lde/justsoftware/mobile/gateway/exception/CommentTooLongException;", "handleThrowable", "t", "", "errorMessage", "mobile-gateway"})
public class MobileGatewayExceptionHandler {
    @ExceptionHandler(value={NotFoundException.class})
    @NotNull
    public ResponseEntity<String> handleNotFoundException(@NotNull NotFoundException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)this.errorMessage((Throwable)e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ForbiddenException.class})
    @NotNull
    public ResponseEntity<String> handleForbiddenException(@NotNull ForbiddenException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)this.errorMessage((Throwable)e), (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InvalidVersionCodeException.class})
    @NotNull
    public ResponseEntity<String> handleInvalidVersionCodeException(@NotNull InvalidVersionCodeException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)this.errorMessage((Throwable)e), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={PostAlreadyUpdatedException.class})
    @NotNull
    public ResponseEntity<String> handlePostAlreadyUpdatedException(@NotNull PostAlreadyUpdatedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)this.errorMessage((Throwable)e), (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={CommentTooLongException.class})
    @NotNull
    public ResponseEntity<String> handleCommentTooLongException(@NotNull CommentTooLongException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)this.errorMessage((Throwable)e), (HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE);
    }

    @ExceptionHandler(value={Throwable.class})
    @NotNull
    public ResponseEntity<String> handleThrowable(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new ResponseEntity((Object)this.errorMessage(t), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private String errorMessage(Throwable $this$errorMessage) {
        return $this$errorMessage.getClass().getName() + ": " + $this$errorMessage.getMessage();
    }
}

