/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.search.SearchAuthorizationContext;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.shares.model.ShareBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.models.Person;
import de.justsoftware.drive.rest.models.Share;
import de.justsoftware.drive.rest.models.ShareCreateModel;
import de.justsoftware.drive.rest.models.ShareDetails;
import de.justsoftware.drive.rest.models.ShareEditModel;
import de.justsoftware.drive.rest.models.SharePermission;
import de.justsoftware.drive.rest.share.SharesFrontendService;
import de.justsoftware.permission.client.model.Role;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shares"}, produces={"application/json"})
@Schema(description="Shares")
@ParametersAreNonnullByDefault
public class ShareController {
    private final SharesService _sharesService;
    private final ItemReadService _itemReadService;
    private final SharesFrontendService _sharesFrontendService;

    @Autowired
    public ShareController(SharesService sharesService, ItemReadService itemReadService, SharesFrontendService sharesFrontendService) {
        this._sharesService = sharesService;
        this._itemReadService = itemReadService;
        this._sharesFrontendService = sharesFrontendService;
    }

    @Operation(description="Retrieves detailed information about a single Share")
    @RequestMapping(value={"/{shareId}"}, method={RequestMethod.GET})
    @Nonnull
    public ShareDetails get(AuthorizationContext authCtx, @PathVariable ItemId shareId) {
        try {
            ShareBO shareDetails = this._sharesService.getShareDetails(shareId, authCtx);
            return this._sharesFrontendService.convertShareBO(shareDetails);
        }
        catch (PermissionDeniedException ex) {
            throw new UnknownResourceException("Share " + shareId + " not found");
        }
    }

    @Operation(description="Retrieves a list of all the user's Shares")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    @Nonnull
    public ImmutableList<Share> get(SearchAuthorizationContext authCtx) {
        return this._sharesFrontendService.convertShareBOs((Iterable)this._sharesService.getShares(authCtx));
    }

    @Operation(description="Creates a new Share")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    @Nonnull
    public Share create(AuthorizationContext authCtx, @RequestBody ShareCreateModel share) {
        PersonId personId = authCtx.getPersonId();
        ItemId shareId = this._sharesService.createShare(authCtx, personId, share.getName(), (Map)this._sharesFrontendService.convertMembers(share.getMembers()));
        this._sharesService.subscribeShare(shareId, personId);
        ImmutableCollection items = this._itemReadService.getItems((Set)ImmutableSet.of((Object)shareId)).values();
        return (Share)this._sharesFrontendService.convertShareBOs((Iterable)items).get(0);
    }

    @Operation(description="Creates an access request for the given Share, notifying all Share members that the logged-in user desires access to the Share.")
    @RequestMapping(value={"/{folderId}/requestAccess"}, method={RequestMethod.POST})
    public void requestAccess(AuthorizationContext authCtx, @PathVariable DocumentId folderId) {
        PersonId personId = authCtx.getPersonId();
        TenantId tenantId = authCtx.getNonnullTenantId();
        this._sharesService.requestAccess(personId, tenantId, folderId);
    }

    @Operation(description="Deletes access requests by a users for the given Share without granting the requested permissions")
    @RequestMapping(value={"/{shareId}/pendingAccessRequests"}, method={RequestMethod.POST})
    public void rejectAccessRequest(AuthorizationContext authCtx, @PathVariable ItemId shareId, @RequestBody List<String> roleStrings) {
        Set roles = roleStrings.stream().map(Role::create).collect(Collectors.toSet());
        this._sharesService.rejectAccessRequests(roles, shareId, authCtx);
    }

    @Operation(description="Retrieves a list of all users that have made a request to access this share.")
    @RequestMapping(value={"/{shareId}/pendingAccessRequests"}, method={RequestMethod.GET})
    @Nonnull
    public List<Person> getAllUsersRequestingAccessToShare(AuthorizationContext authCtx, @PathVariable ItemId shareId) {
        ImmutableSet pendingRequests = this._sharesService.getPendingAccessRequestsForShare(shareId, authCtx);
        return this._sharesFrontendService.getRequestingUsersFromAccessRequests(pendingRequests);
    }

    @Operation(description="Updates an existing Share")
    @RequestMapping(value={"/{shareId}"}, method={RequestMethod.PUT})
    @Nonnull
    public Share edit(AuthorizationContext authCtx, @PathVariable ItemId shareId, @RequestBody ShareEditModel share) {
        PersonId personId = authCtx.getPersonId();
        authCtx.check((AbstractId)shareId, StaticAction.SHARE_MANAGE);
        this._sharesService.editShare(authCtx, shareId, personId, share.getName(), (Map)this._sharesFrontendService.convertMembers(share.getAddedMembers()), (Map)this._sharesFrontendService.convertMembers(share.getUpdatedMembers()), (Set)this._sharesFrontendService.convertMembers(share.getDeletedMembers()).keySet());
        ImmutableCollection items = this._itemReadService.getItems((Set)ImmutableSet.of((Object)shareId)).values();
        return (Share)this._sharesFrontendService.convertShareBOs((Iterable)items).get(0);
    }

    @Operation(description="Adds a user to a Share. If the given user is already a member, nothing is done.")
    @RequestMapping(value={"/{shareId}/addUser/{personId}/{permission}"}, method={RequestMethod.POST})
    public void addUser(AuthorizationContext authCtx, @PathVariable ItemId shareId, @PathVariable PersonId personId, @PathVariable SharePermission permission) {
        PersonId adminId = authCtx.getPersonId();
        authCtx.check((AbstractId)shareId, StaticAction.SHARE_MANAGE);
        ShareBO shareDetails = this._sharesService.getShareDetails(shareId, authCtx);
        if (shareDetails.getProfilePermissionsOnly().containsKey((Object)personId)) {
            return;
        }
        ImmutableMap permissions = shareDetails.getPermissions();
        ImmutableMap addedMembers = ImmutableMap.builder().putAll((Map)permissions).put((Object)personId.asPermissionRole(), (Object)permission.getPrivilege()).build();
        this._sharesService.editShare(authCtx, shareId, adminId, shareDetails.getName(), (Map)addedMembers, (Map)ImmutableMap.of(), (Set)ImmutableSet.of());
    }

    @Operation(description="Deletes a Share")
    @RequestMapping(value={"/{shareId}"}, method={RequestMethod.DELETE})
    public void delete(AuthorizationContext authCtx, @PathVariable ItemId shareId) {
        authCtx.check((AbstractId)shareId, StaticAction.SHARE_MANAGE);
        this._sharesService.deleteShare(shareId);
    }
}

