/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.persistence.document.DocumentMapper;
import de.justsoftware.drive.persistence.file.FileDAO;
import io.micrometer.observation.annotation.Observed;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
@Observed
public class FileDAOImpl
implements FileDAO {
    private final DocumentMapper _documentMapper;

    @Autowired
    public FileDAOImpl(DocumentMapper documentMapper) {
        this._documentMapper = documentMapper;
    }

    public DocumentId createNewFile() {
        return this.createNewFile(Optional.empty());
    }

    public DocumentId createNewFile(Optional<DocumentId> forceId) {
        DocumentId id = forceId.orElseGet(DocumentId::random);
        this._documentMapper.createNewDocument(id);
        return id;
    }
}

