/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.tenant;

import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.tenant.model.TenantId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class KafkaTenantConsumer {
    private static final String TOPIC = "just.tenants";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTenantConsumer.class);
    private final SharesService _sharesService;

    KafkaTenantConsumer(SharesService sharesService) {
        this._sharesService = sharesService;
    }

    @KafkaListener(id="just.drive.tenantConsumer", topics={"just.tenants"}, containerFactory="tenantListenerContainerFactory")
    public void listen(@Nonnull @Header(value="kafka_receivedMessageKey") TenantId key, @Payload(required=false) @Nullable String json) {
        if (json == null) {
            LOG.info("tenant {} deleted message received.", (Object)key);
            this._sharesService.deleteAllShares(key);
        } else {
            LOG.info("Skipping message because tenant: {} was not deleted.", (Object)key);
        }
    }
}

