/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business.impl;

import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessInfo;
import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessor;
import de.justsoftware.drive.business.server.business.UpdateBehaviour;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessorType;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CleanChatAssetFromSolrUpdateProcessor
implements DriveVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CleanChatAssetFromSolrUpdateProcessor.class);
    private final SolrClient _solrClient;

    @Autowired
    public CleanChatAssetFromSolrUpdateProcessor(@Qualifier(value="readSolrClient") SolrClient solrClient) {
        this._solrClient = solrClient;
    }

    public boolean preconditionsMet() {
        try {
            this._solrClient.ping();
            return true;
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Could not run update processor: {}, Solr is not available", (Object)this.getClass().getName(), (Object)e);
            return false;
        }
    }

    @Nonnull
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceForVersion((DriveVersionUpdateProcessInfo)this, (String)"24.6.0");
    }

    public void process() {
        try {
            this._solrClient.deleteByQuery("drive_parent_item_type:CHAT_ASSET");
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Could not run update processor: {}, Reason: {}", (Object)this.getClass().getName(), (Object)e);
        }
    }

    @Nonnull
    public UpdateProcessorType getProcessorType() {
        return new UpdateProcessorType("CLEAN_CHAT_ASSET_SOLR_ENTRIES");
    }
}

