/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import de.justsoftware.drive.business.search.DriveSearchParamsBuilder;
import de.justsoftware.drive.business.search.SearchSortParams;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.util.AbstractImmutableEqualsObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DriveSearchParameters
extends AbstractImmutableEqualsObject {
    final String _searchText;
    final Optional<DocumentId> _searchInFolder;
    final Optional<ItemType> _parentItemType;
    final Optional<ItemId> _grandmaItemId;
    final Optional<Integer> _limit;
    final Optional<Integer> _offset;
    final Optional<SearchSortParams> _sortParams;

    DriveSearchParameters(DriveSearchParamsBuilder params) {
        super(new Object[]{params._searchText, params._searchInFolder, params._parentItemType, params._grandmaItemId, params._sortParams, params._limit, params._offest});
        this._searchText = Strings.nullToEmpty((String)params._searchText);
        this._searchInFolder = Optional.fromNullable((Object)params._searchInFolder);
        this._parentItemType = Optional.fromNullable((Object)params._parentItemType);
        this._grandmaItemId = Optional.fromNullable((Object)params._grandmaItemId);
        this._limit = Optional.fromNullable((Object)params._limit);
        this._offset = Optional.fromNullable((Object)params._offest);
        this._sortParams = Optional.fromNullable((Object)params._sortParams);
    }

    @Nonnull
    public static DriveSearchParamsBuilder builder() {
        return new DriveSearchParamsBuilder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("searchText", (Object)this._searchText).add("searchInFolder", (Object)this._searchInFolder).add("parentItemType", (Object)this._parentItemType).add("grandmaItem", (Object)this._grandmaItemId).add("sortParams", (Object)this._sortParams).add("limit", (Object)this._limit).add("offset", (Object)this._offset).toString();
    }
}

