/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.authorization.oauth2.client.Oauth2Authorizations;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J \u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/authorization/oauth2/client/ExposedOauth2AuthorizationService;", "Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;)V", "findById", "Lorg/springframework/security/oauth2/server/authorization/OAuth2Authorization;", "id", "", "findByToken", "token", "tokenType", "Lorg/springframework/security/oauth2/server/authorization/OAuth2TokenType;", "parseMap", "", "", "data", "remove", "", "authorization", "save", "toOauth2Authorization", "it", "Lorg/jetbrains/exposed/sql/ResultRow;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nExposedOauth2AuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedOauth2AuthorizationService.kt\nde/justsoftware/authorization/oauth2/client/ExposedOauth2AuthorizationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public class ExposedOauth2AuthorizationService
implements OAuth2AuthorizationService {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RegisteredClientRepository registeredClientRepository;

    public ExposedOauth2AuthorizationService(@NotNull ObjectMapper objectMapper, @NotNull RegisteredClientRepository registeredClientRepository2) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository2, (String)"registeredClientRepository");
        this.objectMapper = objectMapper;
        this.registeredClientRepository = registeredClientRepository2;
    }

    public void save(@NotNull OAuth2Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        QueriesKt.upsert$default((Table)((Table)Oauth2Authorizations.INSTANCE), (Column[])new Column[0], null, null, null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)14, null);
    }

    public void remove(@NotNull OAuth2Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        QueriesKt.deleteWhere$default((Table)((Table)Oauth2Authorizations.INSTANCE), null, null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)3, null);
    }

    @Nullable
    public OAuth2Authorization findById(@NotNull String id) {
        OAuth2Authorization oAuth2Authorization;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getId(), (Comparable)UUID.fromString(id)))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            oAuth2Authorization = this.toOauth2Authorization(it);
        } else {
            oAuth2Authorization = null;
        }
        return oAuth2Authorization;
    }

    private OAuth2Authorization toOauth2Authorization(ResultRow it) {
        String refreshTokenValue;
        String oidcIdTokenValue;
        CharSequence authorizationCode;
        String authorizationCodeValue;
        String registeredClientId = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRegisteredClientId());
        RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId);
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
        }
        RegisteredClient registeredClient2 = registeredClient;
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient2).id(((UUID)((EntityID)it.get((Expression)Oauth2Authorizations.INSTANCE.getId())).getValue()).toString()).principalName((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName())).authorizationGrantType(new AuthorizationGrantType((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationGrantType()))).authorizedScopes(StringUtils.commaDelimitedListToSet((String)((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes())))).attributes(arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$1(this, it, arg_0));
        Instant tokenIssuedAt = null;
        Instant tokenExpiresAt = null;
        String accessTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenValue());
        CharSequence charSequence = accessTokenValue;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Map accessTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenMetadata()));
            OAuth2AccessToken.TokenType tokenType = OAuth2AccessToken.TokenType.BEARER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenType, (String)"BEARER");
            OAuth2AccessToken.TokenType tokenType2 = tokenType;
            Set set = StringUtils.commaDelimitedListToSet((String)((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenScopes())));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
            Set accessTokenScopes = set;
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType2, accessTokenValue, tokenIssuedAt, tokenExpiresAt, accessTokenScopes);
            builder.token((OAuth2Token)accessToken, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$2(accessTokenMetadata, arg_0));
        }
        if (StringUtils.hasText((String)(authorizationCodeValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationCodeValue())))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Map authorizationCodeMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationCodeMetadata()));
            authorizationCode = new OAuth2AuthorizationCode(authorizationCodeValue, tokenIssuedAt, tokenExpiresAt);
            builder.token((OAuth2Token)authorizationCode, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$3(authorizationCodeMetadata, arg_0));
        }
        if (!((authorizationCode = (CharSequence)(oidcIdTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenValue()))) == null || StringsKt.isBlank((CharSequence)authorizationCode))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenExpiresAt());
            Map oidcTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenMetadata()));
            OidcIdToken oidcToken = new OidcIdToken(oidcIdTokenValue, tokenIssuedAt, tokenExpiresAt, (Map)oidcTokenMetadata.get(OAuth2Authorization.Token.CLAIMS_METADATA_NAME));
            builder.token((OAuth2Token)oidcToken, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$4(oidcTokenMetadata, arg_0));
        }
        if (StringUtils.hasText((String)(refreshTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenValue())))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenExpiresAt());
            Map refreshTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenMetadata()));
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(refreshTokenValue, tokenIssuedAt, tokenExpiresAt);
            builder.token((OAuth2Token)refreshToken, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$5(refreshTokenMetadata, arg_0));
        }
        OAuth2Authorization oAuth2Authorization = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)oAuth2Authorization, (String)"build(...)");
        return oAuth2Authorization;
    }

    private Map<String, Object> parseMap(String data) {
        try {
            Map map;
            if (data == null) {
                map = MapsKt.emptyMap();
            } else {
                Object object = this.objectMapper.readValue(data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                map = (Map)object;
            }
            return map;
        }
        catch (JacksonException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    @Nullable
    public OAuth2Authorization findByToken(@NotNull String token, @Nullable OAuth2TokenType tokenType) {
        Op predicate;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        OAuth2TokenType oAuth2TokenType = tokenType;
        Object object = Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("code")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAuthorizationCodeValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)OAuth2TokenType.REFRESH_TOKEN) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRefreshTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)OAuth2TokenType.ACCESS_TOKEN) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAccessTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("id_token")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getOidcTokenValue(), (Object)token) : (predicate = Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("state")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getState(), (Object)token) : null))));
        if (predicate != null) {
            OAuth2Authorization oAuth2Authorization;
            oAuth2TokenType = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(predicate)));
            if (oAuth2TokenType != null) {
                OAuth2TokenType it = oAuth2TokenType;
                boolean bl = false;
                oAuth2Authorization = this.toOauth2Authorization((ResultRow)it);
            } else {
                oAuth2Authorization = null;
            }
            return oAuth2Authorization;
        }
        return null;
    }

    private static final void toOauth2Authorization$lambda$1(ExposedOauth2AuthorizationService this$0, ResultRow $it, Map attributes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        attributes.putAll(this$0.parseMap((String)$it.get((Expression)Oauth2Authorizations.INSTANCE.getAttributes())));
    }

    private static final void toOauth2Authorization$lambda$2(Map $accessTokenMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$accessTokenMetadata, (String)"$accessTokenMetadata");
        metadata.putAll($accessTokenMetadata);
    }

    private static final void toOauth2Authorization$lambda$3(Map $authorizationCodeMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$authorizationCodeMetadata, (String)"$authorizationCodeMetadata");
        metadata.putAll($authorizationCodeMetadata);
    }

    private static final void toOauth2Authorization$lambda$4(Map $oidcTokenMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$oidcTokenMetadata, (String)"$oidcTokenMetadata");
        metadata.putAll($oidcTokenMetadata);
    }

    private static final void toOauth2Authorization$lambda$5(Map $refreshTokenMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$refreshTokenMetadata, (String)"$refreshTokenMetadata");
        metadata.putAll($refreshTokenMetadata);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(ExposedOauth2AuthorizationService $this) {
        return $this.objectMapper;
    }
}

