/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import java.time.Instant;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\n"}, d2={"Lde/justsoftware/authorization/oauth2/MobileOauth2RefreshTokenGenerator;", "Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenGenerator;", "Lorg/springframework/security/oauth2/core/OAuth2RefreshToken;", "()V", "refreshTokenGenerator", "Lorg/springframework/security/crypto/keygen/StringKeyGenerator;", "getRefreshTokenGenerator$annotations", "generate", "context", "Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenContext;", "just-authorization-server"})
public final class MobileOauth2RefreshTokenGenerator
implements OAuth2TokenGenerator<OAuth2RefreshToken> {
    @NotNull
    private final StringKeyGenerator refreshTokenGenerator = (StringKeyGenerator)new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);

    private static /* synthetic */ void getRefreshTokenGenerator$annotations() {
    }

    @org.springframework.lang.Nullable
    @Nullable
    public OAuth2RefreshToken generate(@NotNull OAuth2TokenContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)OAuth2TokenType.REFRESH_TOKEN, (Object)context.getTokenType()) || !context.getRegisteredClient().getClientAuthenticationMethods().contains(ClientAuthenticationMethod.NONE)) {
            return null;
        }
        Instant issuedAt = Instant.now();
        Instant expiresAt = issuedAt.plus(context.getRegisteredClient().getTokenSettings().getRefreshTokenTimeToLive());
        return new OAuth2RefreshToken(this.refreshTokenGenerator.generateKey(), issuedAt, expiresAt);
    }
}

