/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.producer;

import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.tenant.model.TrackingSettings;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.TenantProducer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minidev.json.JSONObject;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0012J8\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0012J3\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0010\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "log", "Lorg/slf4j/Logger;", "(Lorg/springframework/kafka/core/KafkaTemplate;Lorg/slf4j/Logger;)V", "generateTrackingSettings", "", "settings", "Lde/justsoftware/admin/domain/tenant/model/TrackingSettings;", "getTenantInformation", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "tenantInvitationCode", "trackingSettings", "publish", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "publish$admin_service", "publishDeletedTenant", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "Companion", "admin-service"})
public class TenantProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaTemplate<String, Object> kafkaTemplate;
    @NotNull
    private final Logger log;
    @NotNull
    private static final String TENANT_TOPIC = "just.tenants";

    public TenantProducer(@NotNull KafkaTemplate<String, Object> kafkaTemplate, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.kafkaTemplate = kafkaTemplate;
        this.log = log;
    }

    public /* synthetic */ TenantProducer(KafkaTemplate kafkaTemplate, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger2 = LoggerFactory.getLogger(TenantProducer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger = logger2;
        }
        this(kafkaTemplate, logger);
    }

    @NotNull
    public KafkaPublishOperation publishDeletedTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.log.debug("Sending key '{}' to kafka topic {} with null message.", (Object)tenantId, (Object)TENANT_TOPIC);
        CompletableFuture completableFuture = this.kafkaTemplate.send(TENANT_TOPIC, (Object)tenantId.toTypedString(), null);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
        CompletableFuture listenable = completableFuture;
        return new KafkaPublishOperation(listenable);
    }

    @NotNull
    public KafkaPublishOperation publish$admin_service(@NotNull Tenant tenant, @NotNull TenantSettings tenantSettings, @Nullable String tenantInvitationCode, @Nullable TrackingSettings trackingSettings) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        String tenantItemId = tenant.getId().toTypedString();
        this.log.debug("Sending tenant to Kafka topic just.tenants with the message : " + tenantItemId + ")");
        Map tenantInformation = this.getTenantInformation(tenantSettings, tenant, tenantInvitationCode, trackingSettings);
        CompletableFuture completableFuture = this.kafkaTemplate.send(new ProducerRecord(TENANT_TOPIC, (Object)tenantItemId, (Object)new JSONObject(tenantInformation).toString()));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
        CompletableFuture listenableFuture = completableFuture;
        return new KafkaPublishOperation(listenableFuture);
    }

    public static /* synthetic */ KafkaPublishOperation publish$admin_service$default(TenantProducer tenantProducer, Tenant tenant, TenantSettings tenantSettings, String string, TrackingSettings trackingSettings, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publish");
        }
        if ((n & 8) != 0) {
            trackingSettings = null;
        }
        return tenantProducer.publish$admin_service(tenant, tenantSettings, string, trackingSettings);
    }

    private Map<String, Object> getTenantInformation(TenantSettings tenantSettings, Tenant tenant, String tenantInvitationCode, TrackingSettings trackingSettings) {
        Map trackingSettingsString = this.generateTrackingSettings(trackingSettings);
        Object[] objectArray = new Pair[6];
        objectArray[0] = tenantInvitationCode != null ? TuplesKt.to((Object)"invitationCode", (Object)tenantInvitationCode) : null;
        objectArray[1] = tenantSettings.getDeeplKey() != null ? TuplesKt.to((Object)"deeplKey", (Object)tenantSettings.getDeeplKey()) : null;
        objectArray[2] = TuplesKt.to((Object)"id", (Object)tenant.getId().toTypedString());
        objectArray[3] = TuplesKt.to((Object)"name", (Object)tenant.getName());
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"GLOBAL_HIGHLIGHT_COLOR", (Object)tenantSettings.getGlobalHighlightColor().toString());
        Object object = tenantSettings.getLogoId();
        if (object == null || (object = object.getValue()) == null || (object = ((UUID)object).toString()) == null) {
            object = "";
        }
        pairArray[1] = TuplesKt.to((Object)"TENANT_LOGO_ID", (Object)object);
        objectArray[4] = TuplesKt.to((Object)"theme", (Object)new JSONObject(MapsKt.mapOf((Pair[])pairArray)));
        objectArray[5] = trackingSettingsString != null ? TuplesKt.to((Object)"trackingSettings", (Object)trackingSettingsString) : null;
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    private Map<String, Object> generateTrackingSettings(TrackingSettings settings) {
        if (settings == null) {
            return null;
        }
        Object[] objectArray = new Pair[]{settings.getMatomoUrl() != null ? TuplesKt.to((Object)"matomoUrl", (Object)settings.getMatomoUrl()) : null, settings.getMatomoSiteId() != null ? TuplesKt.to((Object)"matomoSiteId", (Object)settings.getMatomoSiteId()) : null, settings.getMatomoAuthToken() != null ? TuplesKt.to((Object)"matomoAuthToken", (Object)settings.getMatomoAuthToken()) : null, TuplesKt.to((Object)"cookieBannerEnabled", (Object)settings.getCookieBannerEnabled())};
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }
}

