/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.persistence.AppPermissionRepository;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J+\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0012J&\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "", "appPermissionRepo", "Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;", "(Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;)V", "deletePermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "", "granteeId", "Lde/justsoftware/admin/id/UserId;", "forEachPermission", "", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "appPermission", "getBy", "replacePermission", "origin", "update", "updatePermissions", "adds", "", "removes", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsPermissionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsPermissionService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1855#2:90\n1856#2:92\n1855#2,2:93\n1#3:91\n*S KotlinDebug\n*F\n+ 1 AppSettingsPermissionService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService\n*L\n18#1:90\n18#1:92\n39#1:93,2\n*E\n"})
public class AppSettingsPermissionService {
    @NotNull
    private final AppPermissionRepository appPermissionRepo;

    public AppSettingsPermissionService(@NotNull AppPermissionRepository appPermissionRepo) {
        Intrinsics.checkNotNullParameter((Object)appPermissionRepo, (String)"appPermissionRepo");
        this.appPermissionRepo = appPermissionRepo;
    }

    public void updatePermissions(@NotNull Collection<AppPermission> adds, @NotNull Collection<AppPermission> removes) {
        AppPermission it;
        Intrinsics.checkNotNullParameter(adds, (String)"adds");
        Intrinsics.checkNotNullParameter(removes, (String)"removes");
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)adds);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AppPermission)element$iv;
            boolean bl = false;
            if (it.getRole().isVsl()) {
                Object v0;
                block5: {
                    Iterable iterable = this.appPermissionRepo.findByTenantIdAndAppAndGranteeId(it.getTenantId(), it.getApp(), it.getGranteeId());
                    for (Object t : iterable) {
                        AppPermission origin = (AppPermission)t;
                        boolean bl2 = false;
                        if (!origin.getRole().isVsl()) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                AppPermission originVsl = v0;
                if (originVsl == null) {
                    this.appPermissionRepo.insert(it.getTenantId(), it.getApp(), it.getGranteeId(), it.getRole());
                    continue;
                }
                if (!it.getRole().shouldReplace(originVsl.getRole())) continue;
                this.replacePermission(originVsl, it);
                continue;
            }
            this.appPermissionRepo.insert(it.getTenantId(), it.getApp(), it.getGranteeId(), it.getRole());
        }
        $this$forEach$iv = CollectionsKt.toSet((Iterable)removes);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AppPermission)element$iv;
            boolean bl = false;
            this.appPermissionRepo.deleteOne(it.getTenantId(), it.getApp(), it.getGranteeId(), it.getRole());
        }
    }

    public static /* synthetic */ void updatePermissions$default(AppSettingsPermissionService appSettingsPermissionService, Collection collection, Collection collection2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updatePermissions");
        }
        if ((n & 2) != 0) {
            collection2 = SetsKt.emptySet();
        }
        appSettingsPermissionService.updatePermissions(collection, collection2);
    }

    @NotNull
    public Set<AppPermission> getBy(@NotNull TenantId tenantId, @Nullable CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (app == null) {
            return this.appPermissionRepo.findBy(tenantId);
        }
        return this.appPermissionRepo.getMany(tenantId, app);
    }

    public static /* synthetic */ Set getBy$default(AppSettingsPermissionService appSettingsPermissionService, TenantId tenantId, CoreApp coreApp, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBy");
        }
        if ((n & 2) != 0) {
            coreApp = null;
        }
        return appSettingsPermissionService.getBy(tenantId, coreApp);
    }

    public void forEachPermission(@NotNull Function1<? super AppPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.appPermissionRepo.forEach(consumer);
    }

    @NotNull
    public List<AppPermission> deletePermissions(@NotNull UserId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List toDelete = this.appPermissionRepo.getAllForGrantee(granteeId);
        this.appPermissionRepo.deleteAllForGrantee(granteeId);
        return toDelete;
    }

    @NotNull
    public Set<AppPermission> deletePermissions(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Set toDelete = this.appPermissionRepo.getMany(tenantId, app);
        this.appPermissionRepo.deleteAll(tenantId, app);
        return toDelete;
    }

    private void replacePermission(AppPermission origin, AppPermission update) {
        this.appPermissionRepo.deleteOne(origin.getTenantId(), origin.getApp(), origin.getGranteeId(), origin.getRole());
        this.appPermissionRepo.insert(update.getTenantId(), update.getApp(), update.getGranteeId(), update.getRole());
    }
}

