/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.people;

import de.justsoftware.admin.connector.people.PeopleConnector;
import de.justsoftware.admin.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/admin/connector/people/PeopleConnector;", "", "url", "", "(Ljava/lang/String;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "getBirthdayListEnabled", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "(Lde/justsoftware/admin/id/TenantId;)Ljava/lang/Boolean;", "setBirthdayListEnabled", "", "isEnabled", "BirthdayListEnabledDto", "admin-service"})
@SourceDebugExtension(value={"SMAP\nPeopleConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleConnector.kt\nde/justsoftware/admin/connector/people/PeopleConnector\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,34:1\n43#2:35\n*S KotlinDebug\n*F\n+ 1 PeopleConnector.kt\nde/justsoftware/admin/connector/people/PeopleConnector\n*L\n29#1:35\n*E\n"})
public class PeopleConnector {
    @NotNull
    private final String url;
    @NotNull
    private final RestClient restClient;

    public PeopleConnector(@Value(value="${just.people.internal}") @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        RestClient restClient = RestClient.create();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"create(...)");
        this.restClient = restClient;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setBirthdayListEnabled(@NotNull TenantId tenantId, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        String uri = isEnabled ? this.url + "/" + tenantId + "/birthdayList/enable" : this.url + "/" + tenantId + "/birthdayList/disable";
        ((RestClient.RequestBodySpec)this.getRestClient().post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).retrieve().toBodilessEntity();
    }

    @Nullable
    public Boolean getBirthdayListEnabled(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = this.getRestClient().get().uri(this.url + "/" + tenantId + "/birthdayList", new Object[0]).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        BirthdayListEnabledDto birthdayListEnabledDto = (BirthdayListEnabledDto)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return birthdayListEnabledDto != null ? Boolean.valueOf(birthdayListEnabledDto.getEnabled()) : null;
    }
}

