/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.filter;

import de.justsoftware.authentication.service.AuthenticationMetricsService;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLEntryPoint;

@ParametersAreNonnullByDefault
public class JustSAMLEntryPoint
extends SAMLEntryPoint {
    private AuthenticationMetricsService _metrics;

    @Autowired(required=true)
    public void setMetricsService(AuthenticationMetricsService metrics) {
        this._metrics = metrics;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authEx) throws IOException, ServletException {
        try {
            super.commence(request, response, authEx);
            this._metrics.loginAttempt();
        }
        catch (IOException | ServletException e) {
            this._metrics.loginError();
            throw e;
        }
    }
}

