/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.cli.CLIO;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.RTimer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated(since="9.2")
public class SimplePostTool {
    private static final String DEFAULT_POST_HOST = "localhost";
    private static final String DEFAULT_POST_PORT = "8983";
    private static final String VERSION_OF_THIS_TOOL = "9.6.0";
    private static final String DEFAULT_COMMIT = "yes";
    private static final String DEFAULT_OPTIMIZE = "no";
    private static final String DEFAULT_OUT = "no";
    private static final String DEFAULT_AUTO = "no";
    private static final String DEFAULT_RECURSIVE = "0";
    private static final int DEFAULT_WEB_DELAY = 10;
    private static final int MAX_WEB_DEPTH = 10;
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final String DEFAULT_FILE_TYPES = "xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log";
    private static final String BASIC_AUTH = "basicauth";
    static final String DATA_MODE_FILES = "files";
    static final String DATA_MODE_ARGS = "args";
    static final String DATA_MODE_STDIN = "stdin";
    static final String DATA_MODE_WEB = "web";
    static final String DEFAULT_DATA_MODE = "files";
    static final String FORMAT_SOLR = "solr";
    boolean auto = false;
    int recursive = 0;
    int delay = 0;
    String fileTypes;
    URL solrUrl;
    OutputStream out = null;
    String type;
    String format;
    String mode;
    boolean commit;
    boolean optimize;
    String[] args;
    private int currentDepth;
    static HashMap<String, String> mimeMap;
    FileFilter fileFilter;
    List<LinkedHashSet<URI>> backlog = new ArrayList<LinkedHashSet<URI>>();
    Set<URI> visited = new HashSet<URI>();
    static final Set<String> DATA_MODES;
    static final String USAGE_STRING_SHORT = "Usage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|url|arg> [<file|folder|url|arg>...]]";
    boolean mockMode = false;
    PageFetcher pageFetcher;

    public static void main(String[] args) {
        SimplePostTool.info("SimplePostTool version 9.6.0");
        if (0 < args.length && ("-help".equals(args[0]) || "--help".equals(args[0]) || "-h".equals(args[0]))) {
            SimplePostTool.usage();
        } else {
            SimplePostTool t = SimplePostTool.parseArgsAndInit(args);
            t.execute();
        }
    }

    public void execute() {
        RTimer timer = new RTimer();
        if ("files".equals(this.mode) && this.args.length > 0) {
            this.doFilesMode();
        } else if (DATA_MODE_ARGS.equals(this.mode) && this.args.length > 0) {
            this.doArgsMode();
        } else if (DATA_MODE_WEB.equals(this.mode) && this.args.length > 0) {
            this.doWebMode();
        } else if (DATA_MODE_STDIN.equals(this.mode)) {
            this.doStdinMode();
        } else {
            SimplePostTool.usageShort();
            return;
        }
        if (this.commit) {
            this.commit();
        }
        if (this.optimize) {
            this.optimize();
        }
        this.displayTiming((long)timer.getTime());
    }

    private void displayTiming(long millis) {
        SimpleDateFormat df = new SimpleDateFormat("H:mm:ss.SSS", Locale.getDefault());
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        CLIO.out("Time spent: " + df.format(new Date(millis)));
    }

    protected static SimplePostTool parseArgsAndInit(String[] args) {
        String urlStr = null;
        try {
            int recursive;
            String format;
            String type;
            boolean auto;
            URL url;
            String mode;
            block13: {
                mode = System.getProperty("data", "files");
                if (!DATA_MODES.contains(mode)) {
                    SimplePostTool.fatal("System Property 'data' is not valid for this tool: " + mode);
                }
                String params = System.getProperty("params", "");
                String host = System.getProperty("host", DEFAULT_POST_HOST);
                String port = System.getProperty("port", DEFAULT_POST_PORT);
                String core = System.getProperty("c");
                urlStr = System.getProperty("url");
                if (urlStr == null && core == null) {
                    SimplePostTool.fatal("Specifying either url or core/collection is mandatory.\nUsage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|url|arg> [<file|folder|url|arg>...]]");
                }
                if (urlStr == null) {
                    urlStr = String.format(Locale.ROOT, "http://%s:%s/solr/%s/update", host, port, core);
                }
                urlStr = SimplePostTool.appendParam(urlStr, params);
                url = new URL(urlStr);
                String user = null;
                if (url.getUserInfo() != null && url.getUserInfo().trim().length() > 0) {
                    user = url.getUserInfo().split(":")[0];
                } else if (System.getProperty(BASIC_AUTH) != null) {
                    user = System.getProperty(BASIC_AUTH).trim().split(":")[0];
                }
                if (user != null) {
                    SimplePostTool.info("Basic Authentication enabled, user=" + user);
                }
                auto = SimplePostTool.isOn(System.getProperty("auto", "no"));
                type = System.getProperty("type");
                format = System.getProperty("format");
                recursive = 0;
                String r = System.getProperty("recursive", DEFAULT_RECURSIVE);
                try {
                    recursive = Integer.parseInt(r);
                }
                catch (Exception e) {
                    if (!SimplePostTool.isOn(r)) break block13;
                    recursive = DATA_MODE_WEB.equals(mode) ? 1 : 999;
                }
            }
            int delay = DATA_MODE_WEB.equals(mode) ? 10 : 0;
            try {
                delay = Integer.parseInt(System.getProperty("delay", "" + delay));
            }
            catch (Exception exception) {
                // empty catch block
            }
            PrintStream out = SimplePostTool.isOn(System.getProperty("out", "no")) ? CLIO.getOutStream() : null;
            String fileTypes = System.getProperty("filetypes", DEFAULT_FILE_TYPES);
            boolean commit = SimplePostTool.isOn(System.getProperty("commit", DEFAULT_COMMIT));
            boolean optimize = SimplePostTool.isOn(System.getProperty("optimize", "no"));
            return new SimplePostTool(mode, url, auto, type, format, recursive, delay, fileTypes, out, commit, optimize, args);
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("System Property 'url' is not a valid URL: " + urlStr);
            return null;
        }
    }

    public SimplePostTool(String mode, URL url, boolean auto, String type, String format, int recursive, int delay, String fileTypes, OutputStream out, boolean commit, boolean optimize, String[] args) {
        this.mode = mode;
        this.solrUrl = url;
        this.auto = auto;
        this.type = type;
        this.format = format;
        this.recursive = recursive;
        this.delay = delay;
        this.fileTypes = fileTypes;
        this.fileFilter = this.getFileFilterFromFileTypes(fileTypes);
        this.out = out;
        this.commit = commit;
        this.optimize = optimize;
        this.args = args;
        this.pageFetcher = new PageFetcher();
    }

    public SimplePostTool() {
    }

    private void doFilesMode() {
        this.currentDepth = 0;
        if (!this.args[0].equals("-")) {
            SimplePostTool.info("Posting files to [base] url " + this.solrUrl + (String)(!this.auto ? " using content-type " + (this.type == null ? DEFAULT_CONTENT_TYPE : this.type) : "") + "...");
            if (this.auto) {
                SimplePostTool.info("Entering auto mode. File endings considered are " + this.fileTypes);
            }
            if (this.recursive > 0) {
                SimplePostTool.info("Entering recursive mode, max depth=" + this.recursive + ", delay=" + this.delay + "s");
            }
            int numFilesPosted = this.postFiles(this.args, 0, this.out, this.type);
            SimplePostTool.info(numFilesPosted + " files indexed.");
        }
    }

    private void doArgsMode() {
        SimplePostTool.info("POSTing args to " + this.solrUrl + "...");
        for (String a : this.args) {
            this.postData(SimplePostTool.stringToStream(a), null, this.out, this.type, this.solrUrl);
        }
    }

    private void doWebMode() {
        this.reset();
        int numPagesPosted = 0;
        try {
            if (this.type != null) {
                SimplePostTool.fatal("Specifying content-type with \"-Ddata=web\" is not supported");
            }
            if (this.args[0].equals("-")) {
                return;
            }
            this.solrUrl = SimplePostTool.appendUrlPath(this.solrUrl, "/extract");
            SimplePostTool.info("Posting web pages to Solr url " + this.solrUrl);
            this.auto = true;
            SimplePostTool.info("Entering auto mode. Indexing pages with content-types corresponding to file endings " + this.fileTypes);
            if (this.recursive > 0) {
                if (this.recursive > 10) {
                    this.recursive = 10;
                    SimplePostTool.warn("Too large recursion depth for web mode, limiting to 10...");
                }
                if (this.delay < 10) {
                    SimplePostTool.warn("Never crawl an external web site faster than every 10 seconds, your IP will probably be blocked");
                }
                SimplePostTool.info("Entering recursive mode, depth=" + this.recursive + ", delay=" + this.delay + "s");
            }
            numPagesPosted = this.postWebPages(this.args, 0, this.out);
            SimplePostTool.info(numPagesPosted + " web pages indexed.");
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("Wrong URL trying to append /extract to " + this.solrUrl);
        }
    }

    private void doStdinMode() {
        SimplePostTool.info("POSTing stdin to " + this.solrUrl + "...");
        this.postData(System.in, null, this.out, this.type, this.solrUrl);
    }

    private void reset() {
        this.backlog = new ArrayList<LinkedHashSet<URI>>();
        this.visited = new HashSet<URI>();
    }

    private static void usageShort() {
        CLIO.out("Usage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|url|arg> [<file|folder|url|arg>...]]\n       Please invoke with -h option for extended usage help.");
    }

    private static void usage() {
        CLIO.out("Usage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|url|arg> [<file|folder|url|arg>...]]\n\nSupported System Properties and their defaults:\n  -Dc=<core/collection>\n  -Durl=<base Solr update URL> (overrides -Dc option if specified)\n  -Ddata=files|web|args|stdin (default=files)\n  -Dtype=<content-type> (default=application/json  -Dhost=<host> (default: )\nlocalhost)\n  -Dport=<port> (default: 8983)\n  -Dbasicauth=<user:pass> (sets Basic Authentication credentials)\n  -Dauto=yes|no (default=no)\n  -Drecursive=yes|no|<depth> (default=0)\n  -Ddelay=<seconds> (default=0 for files, 10 for web)\n  -Dfiletypes=<type>[,<type>,...] (default=xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log)\n  -Dparams=\"<key>=<value>[&<key>=<value>...]\" (values must be URL-encoded)\n  -Dcommit=yes|no (default=yes)\n  -Doptimize=yes|no (default=no)\n  -Dout=yes|no (default=no)\n\nThis is a simple command line tool for POSTing raw data to a Solr port.\nNOTE: Specifying the url/core/collection name is mandatory.\nData can be read from files specified as commandline args,\nURLs specified as args, as raw commandline arg strings or via STDIN.\nExamples:\n  java -Dc=gettingstarted -jar post.jar *.xml\n  java -Ddata=args -Dc=gettingstarted -jar post.jar '<delete><id>42</id></delete>'\n  java -Ddata=stdin -Dc=gettingstarted -jar post.jar < hd.xml\n  java -Ddata=web -Dc=gettingstarted -jar post.jar http://example.com/\n  java -Dtype=text/csv -Dc=gettingstarted -jar post.jar *.csv\n  java -Dtype=application/json -Dc=gettingstarted -jar post.jar *.json\n  java -Durl=http://localhost:8983/solr/techproducts/update/extract -Dparams=literal.id=pdf1 -jar post.jar solr-word.pdf\n  java -Dauto -Dc=gettingstarted -jar post.jar *\n  java -Dauto -Dc=gettingstarted -Drecursive -jar post.jar afolder\n  java -Dauto -Dc=gettingstarted -Dfiletypes=ppt,html -jar post.jar afolder\nThe options controlled by System Properties include the Solr\nURL to POST to, the Content-Type of the data, whether a commit\nor optimize should be executed, and whether the response should\nbe written to STDOUT. If auto=yes the tool will try to set type\nautomatically from file name. When posting rich documents the\nfile name will be propagated as \"resource.name\" and also used\nas \"literal.id\". You may override these or any other request parameter\nthrough the -Dparams property. To do a commit only, use \"-\" as argument.\nThe web mode is a simple crawler following links within domain, default delay=10s.");
    }

    private boolean checkIsValidPath(File srcFile) {
        try {
            srcFile.toPath();
            return true;
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public int postFiles(String[] args, int startIndexInArgs, OutputStream out, String type) {
        this.reset();
        int filesPosted = 0;
        for (int j = startIndexInArgs; j < args.length; ++j) {
            File srcFile = new File(args[j]);
            filesPosted = this.getFilesPosted(out, type, srcFile);
        }
        return filesPosted;
    }

    public int postFiles(File[] files, int startIndexInArgs, OutputStream out, String type) {
        this.reset();
        int filesPosted = 0;
        for (File srcFile : files) {
            filesPosted = this.getFilesPosted(out, type, srcFile);
        }
        return filesPosted;
    }

    private int getFilesPosted(OutputStream out, String type, File srcFile) {
        int filesPosted = 0;
        boolean isValidPath = this.checkIsValidPath(srcFile);
        filesPosted = isValidPath && srcFile.isDirectory() && srcFile.canRead() ? (filesPosted += this.postDirectory(srcFile, out, type)) : (isValidPath && srcFile.isFile() && srcFile.canRead() ? (filesPosted += this.postFiles(new File[]{srcFile}, out, type)) : (filesPosted += this.handleGlob(srcFile, out, type)));
        return filesPosted;
    }

    private int postDirectory(File dir, OutputStream out, String type) {
        if (dir.isHidden() && !dir.getName().equals(".")) {
            return 0;
        }
        SimplePostTool.info("Indexing directory " + dir.getPath() + " (" + dir.listFiles(this.fileFilter).length + " files, depth=" + this.currentDepth + ")");
        int posted = 0;
        posted += this.postFiles(dir.listFiles(this.fileFilter), out, type);
        if (this.recursive > this.currentDepth) {
            for (File d : dir.listFiles()) {
                if (!d.isDirectory()) continue;
                ++this.currentDepth;
                posted += this.postDirectory(d, out, type);
                --this.currentDepth;
            }
        }
        return posted;
    }

    int postFiles(File[] files, OutputStream out, String type) {
        int filesPosted = 0;
        for (File srcFile : files) {
            try {
                if (!srcFile.isFile() || srcFile.isHidden()) continue;
                this.postFile(srcFile, out, type);
                Thread.sleep((long)this.delay * 1000L);
                ++filesPosted;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return filesPosted;
    }

    int handleGlob(File globFile, OutputStream out, String type) {
        String fileGlob;
        GlobFileFilter ff;
        File[] fileList;
        int filesPosted = 0;
        File parent = globFile.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        if ((fileList = parent.listFiles(ff = new GlobFileFilter(fileGlob = globFile.getName(), false))) == null || fileList.length == 0) {
            SimplePostTool.warn("No files or directories matching " + globFile);
        } else {
            filesPosted = this.postFiles(fileList, out, type);
        }
        return filesPosted;
    }

    public int postWebPages(String[] args, int startIndexInArgs, OutputStream out) {
        this.reset();
        LinkedHashSet<URI> s = new LinkedHashSet<URI>();
        for (int j = startIndexInArgs; j < args.length; ++j) {
            try {
                URI uri = new URI(SimplePostTool.normalizeUrlEnding(args[j]));
                s.add(uri);
                continue;
            }
            catch (URISyntaxException e) {
                SimplePostTool.warn("Skipping malformed input URL: " + args[j]);
            }
        }
        this.backlog.add(s);
        return this.webCrawl(0, out);
    }

    protected static String normalizeUrlEnding(String link) {
        if (link.contains("#")) {
            link = link.substring(0, link.indexOf(35));
        }
        if (link.endsWith("?")) {
            link = link.substring(0, link.length() - 1);
        }
        if (link.endsWith("/")) {
            link = link.substring(0, link.length() - 1);
        }
        return link;
    }

    protected int webCrawl(int level, OutputStream out) {
        int numPages = 0;
        LinkedHashSet<URI> stack = this.backlog.get(level);
        int rawStackSize = stack.size();
        stack.removeAll(this.visited);
        int stackSize = stack.size();
        LinkedHashSet<URI> subStack = new LinkedHashSet<URI>();
        SimplePostTool.info("Entering crawl at level " + level + " (" + rawStackSize + " links total, " + stackSize + " new)");
        for (URI uri : stack) {
            try {
                this.visited.add(uri);
                URL url = uri.toURL();
                PageFetcherResult result = this.pageFetcher.readPageFromUrl(url);
                if (result.httpStatus == 200) {
                    url = result.redirectUrl != null ? result.redirectUrl : url;
                    URL postUrl = new URL(SimplePostTool.appendParam(this.solrUrl.toString(), "literal.id=" + URLEncoder.encode(url.toString(), StandardCharsets.UTF_8) + "&literal.url=" + URLEncoder.encode(url.toString(), StandardCharsets.UTF_8)));
                    ByteBuffer content = result.content;
                    boolean success = this.postData(new ByteArrayInputStream(content.array(), content.arrayOffset(), content.limit()), null, out, result.contentType, postUrl);
                    if (success) {
                        SimplePostTool.info("POSTed web resource " + url + " (depth: " + level + ")");
                        Thread.sleep((long)this.delay * 1000L);
                        ++numPages;
                        if (this.recursive <= level || !result.contentType.equals("text/html")) continue;
                        Set<URI> children = this.pageFetcher.getLinksFromWebPage(url, new ByteArrayInputStream(content.array(), content.arrayOffset(), content.limit()), result.contentType, postUrl);
                        subStack.addAll(children);
                        continue;
                    }
                    SimplePostTool.warn("An error occurred while posting " + uri);
                    continue;
                }
                SimplePostTool.warn("The URL " + uri + " returned a HTTP result status of " + result.httpStatus);
            }
            catch (IOException | URISyntaxException e) {
                SimplePostTool.warn("Caught exception when trying to open connection to " + uri + ": " + e.getMessage());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!subStack.isEmpty()) {
            this.backlog.add(subStack);
            numPages += this.webCrawl(level + 1, out);
        }
        return numPages;
    }

    protected String computeFullUrl(URL baseUrl, String link) {
        String l;
        if (link == null || ((String)link).length() == 0) {
            return null;
        }
        if (!((String)link).startsWith("http")) {
            if (((String)link).startsWith("/")) {
                link = baseUrl.getProtocol() + "://" + baseUrl.getAuthority() + (String)link;
            } else {
                int sep;
                String file;
                if (((String)link).contains(":")) {
                    return null;
                }
                String path = baseUrl.getPath();
                if (!path.endsWith("/") && ((file = path.substring((sep = path.lastIndexOf(47)) + 1)).contains(".") || file.contains("?"))) {
                    path = path.substring(0, sep);
                }
                link = baseUrl.getProtocol() + "://" + baseUrl.getAuthority() + path + "/" + (String)link;
            }
        }
        if ((l = ((String)(link = SimplePostTool.normalizeUrlEnding((String)link))).toLowerCase(Locale.ROOT)).endsWith(".jpg") || l.endsWith(".jpeg") || l.endsWith(".png") || l.endsWith(".gif")) {
            return null;
        }
        return link;
    }

    protected boolean typeSupported(String type) {
        for (Map.Entry<String, String> entry : mimeMap.entrySet()) {
            if (!entry.getValue().equals(type) || !this.fileTypes.contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    protected static boolean isOn(String property) {
        return "true,on,yes,1".contains(property);
    }

    static void warn(String msg) {
        CLIO.err("SimplePostTool: WARNING: " + msg);
    }

    static void info(String msg) {
        CLIO.out(msg);
    }

    static void fatal(String msg) {
        CLIO.err("SimplePostTool: FATAL: " + msg);
        System.exit(2);
    }

    public void commit() {
        SimplePostTool.info("COMMITting Solr index changes to " + this.solrUrl + "...");
        this.doGet(SimplePostTool.appendParam(this.solrUrl.toString(), "commit=true"));
    }

    public void optimize() {
        SimplePostTool.info("Performing an OPTIMIZE to " + this.solrUrl + "...");
        this.doGet(SimplePostTool.appendParam(this.solrUrl.toString(), "optimize=true"));
    }

    public static String appendParam(String url, String param) {
        String[] pa;
        for (String p : pa = param.split("&")) {
            if (p.trim().length() == 0) continue;
            String[] kv = p.split("=");
            if (kv.length == 2) {
                url = (String)url + (((String)url).contains("?") ? "&" : "?") + kv[0] + "=" + kv[1];
                continue;
            }
            SimplePostTool.warn("Skipping param " + p + " which is not on form key=value");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFile(File file, OutputStream output, String type) {
        InputStream is = null;
        try {
            URL url = this.solrUrl;
            String suffix = "";
            if (this.auto) {
                if (type == null) {
                    type = SimplePostTool.guessType(file);
                }
                if (type.equals(DEFAULT_CONTENT_TYPE) && !FORMAT_SOLR.equals(this.format)) {
                    suffix = "/json/docs";
                    String urlStr = SimplePostTool.appendUrlPath(this.solrUrl, suffix).toString();
                    url = new URL(urlStr);
                } else if (!(type.equals("application/xml") || type.equals("text/csv") || type.equals(DEFAULT_CONTENT_TYPE))) {
                    suffix = "/extract";
                    String urlStr = SimplePostTool.appendUrlPath(this.solrUrl, suffix).toString();
                    if (!urlStr.contains("resource.name")) {
                        urlStr = SimplePostTool.appendParam(urlStr, "resource.name=" + URLEncoder.encode(file.getAbsolutePath(), StandardCharsets.UTF_8));
                    }
                    if (!urlStr.contains("literal.id")) {
                        urlStr = SimplePostTool.appendParam(urlStr, "literal.id=" + URLEncoder.encode(file.getAbsolutePath(), StandardCharsets.UTF_8));
                    }
                    url = new URL(urlStr);
                }
            } else if (type == null) {
                type = DEFAULT_CONTENT_TYPE;
            }
            SimplePostTool.info("POSTing file " + file.getName() + (String)(this.auto ? " (" + type + ")" : "") + " to [base]" + suffix + (this.mockMode ? " MOCK!" : ""));
            is = new FileInputStream(file);
            this.postData(is, file.length(), output, type, url);
        }
        catch (IOException e) {
            SimplePostTool.warn("Can't open/read file: " + file);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while closing file: " + e);
            }
        }
    }

    protected static URL appendUrlPath(URL url, String append) throws MalformedURLException {
        return new URL(url.getProtocol() + "://" + url.getAuthority() + url.getPath() + append + (String)(url.getQuery() != null ? "?" + url.getQuery() : ""));
    }

    protected static String guessType(File file) {
        String name = file.getName();
        String suffix = name.substring(name.lastIndexOf(46) + 1);
        String type = mimeMap.get(suffix.toLowerCase(Locale.ROOT));
        return type != null ? type : "application/octet-stream";
    }

    public void doGet(String url) {
        try {
            this.doGet(new URL(url));
        }
        catch (MalformedURLException e) {
            SimplePostTool.warn("The specified URL " + url + " is not a valid URL. Please check");
        }
    }

    public void doGet(URL url) {
        try {
            if (this.mockMode) {
                return;
            }
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            SimplePostTool.basicAuth(urlc);
            urlc.connect();
            SimplePostTool.checkResponseCode(urlc);
        }
        catch (IOException e) {
            SimplePostTool.warn("An error occurred getting data from " + url + ". Please check that Solr is running.");
        }
        catch (Exception e) {
            SimplePostTool.warn("An error occurred getting data from " + url + ". Message: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postData(InputStream data, Long length, OutputStream output, String type, URL url) {
        if (this.mockMode) {
            return true;
        }
        boolean success = true;
        if (type == null) {
            type = DEFAULT_CONTENT_TYPE;
        }
        HttpURLConnection urlConnection = null;
        try {
            try {
                urlConnection = (HttpURLConnection)url.openConnection();
                try {
                    urlConnection.setRequestMethod("POST");
                }
                catch (ProtocolException e) {
                    SimplePostTool.fatal("Shouldn't happen: HttpURLConnection doesn't support POST??" + e);
                }
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setUseCaches(false);
                urlConnection.setAllowUserInteraction(false);
                urlConnection.setRequestProperty("Content-type", type);
                SimplePostTool.basicAuth(urlConnection);
                if (null != length) {
                    urlConnection.setFixedLengthStreamingMode(length);
                } else {
                    urlConnection.setChunkedStreamingMode(-1);
                }
                urlConnection.connect();
            }
            catch (IOException e) {
                SimplePostTool.fatal("Connection error (is Solr running at " + this.solrUrl + " ?): " + e);
                success = false;
            }
            catch (Exception e) {
                SimplePostTool.fatal("POST failed with error " + e.getMessage());
            }
            try (OutputStream out = urlConnection.getOutputStream();){
                SimplePostTool.pipe(data, out);
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while posting data: " + e);
            }
            try {
                success &= SimplePostTool.checkResponseCode(urlConnection);
                try (InputStream in = urlConnection.getInputStream();){
                    SimplePostTool.pipe(in, output);
                }
            }
            catch (IOException e) {
                SimplePostTool.warn("IOException while reading response: " + e);
                success = false;
            }
            catch (GeneralSecurityException e) {
                SimplePostTool.fatal("Looks like Solr is secured and would not let us in. Try with another user in '-u' parameter");
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return success;
    }

    private static void basicAuth(HttpURLConnection urlc) throws Exception {
        if (urlc.getURL().getUserInfo() != null) {
            String encoding = Base64.getEncoder().encodeToString(urlc.getURL().getUserInfo().getBytes(StandardCharsets.US_ASCII));
            urlc.setRequestProperty("Authorization", "Basic " + encoding);
        } else if (System.getProperty(BASIC_AUTH) != null) {
            String basicauth = System.getProperty(BASIC_AUTH).trim();
            if (!basicauth.contains(":")) {
                throw new Exception("System property 'basicauth' must be of format user:pass");
            }
            urlc.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(basicauth.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static boolean checkResponseCode(HttpURLConnection urlc) throws IOException, GeneralSecurityException {
        if (urlc.getResponseCode() >= 400) {
            int idx;
            SimplePostTool.warn("Solr returned an error #" + urlc.getResponseCode() + " (" + urlc.getResponseMessage() + ") for url: " + urlc.getURL());
            Charset charset = StandardCharsets.ISO_8859_1;
            String contentType = urlc.getContentType();
            if (contentType != null && (idx = contentType.toLowerCase(Locale.ROOT).indexOf("charset=")) > 0) {
                charset = Charset.forName(contentType.substring(idx + "charset=".length()).trim());
            }
            try (InputStream errStream = urlc.getErrorStream();){
                if (errStream != null) {
                    int ch;
                    BufferedReader br = new BufferedReader(new InputStreamReader(errStream, charset));
                    StringBuilder response = new StringBuilder("Response: ");
                    while ((ch = br.read()) != -1) {
                        response.append((char)ch);
                    }
                    SimplePostTool.warn(response.toString().trim());
                }
            }
            if (urlc.getResponseCode() == 401) {
                throw new GeneralSecurityException("Solr requires authentication (response 401). Please try again with '-u' option");
            }
            if (urlc.getResponseCode() == 403) {
                throw new GeneralSecurityException("You are not authorized to perform this action against Solr. (response 403)");
            }
            return false;
        }
        return true;
    }

    public static InputStream stringToStream(String s) {
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }

    private static void pipe(InputStream source, OutputStream dest) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = source.read(buf)) >= 0) {
            if (null == dest) continue;
            dest.write(buf, 0, read);
        }
        if (null != dest) {
            dest.flush();
        }
    }

    public FileFilter getFileFilterFromFileTypes(String fileTypes) {
        Object glob = fileTypes.equals("*") ? ".*" : "^.*\\.(" + fileTypes.replace(",", "|") + ")$";
        return new GlobFileFilter((String)glob, true);
    }

    public static NodeList getNodesFromXP(Node n, String xpath) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xp = factory.newXPath();
        XPathExpression expr = xp.compile(xpath);
        return (NodeList)expr.evaluate(n, XPathConstants.NODESET);
    }

    public static String getXP(Node n, String xpath, boolean concatAll) throws XPathExpressionException {
        NodeList nodes = SimplePostTool.getNodesFromXP(n, xpath);
        StringBuilder sb = new StringBuilder();
        if (nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                sb.append(nodes.item(i).getNodeValue()).append(' ');
                if (!concatAll) break;
            }
            return sb.toString().trim();
        }
        return "";
    }

    public static Document makeDom(byte[] in) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream is = new ByteArrayInputStream(in);
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        return dom;
    }

    static {
        DATA_MODES = new HashSet<String>();
        DATA_MODES.add("files");
        DATA_MODES.add(DATA_MODE_ARGS);
        DATA_MODES.add(DATA_MODE_STDIN);
        DATA_MODES.add(DATA_MODE_WEB);
        mimeMap = new HashMap();
        mimeMap.put("xml", "application/xml");
        mimeMap.put("csv", "text/csv");
        mimeMap.put("json", DEFAULT_CONTENT_TYPE);
        mimeMap.put("jsonl", "application/jsonl");
        mimeMap.put("pdf", "application/pdf");
        mimeMap.put("rtf", "text/rtf");
        mimeMap.put("html", "text/html");
        mimeMap.put("htm", "text/html");
        mimeMap.put("doc", "application/msword");
        mimeMap.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeMap.put("ppt", "application/vnd.ms-powerpoint");
        mimeMap.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeMap.put("xls", "application/vnd.ms-excel");
        mimeMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeMap.put("odt", "application/vnd.oasis.opendocument.text");
        mimeMap.put("ott", "application/vnd.oasis.opendocument.text");
        mimeMap.put("odp", "application/vnd.oasis.opendocument.presentation");
        mimeMap.put("otp", "application/vnd.oasis.opendocument.presentation");
        mimeMap.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        mimeMap.put("ots", "application/vnd.oasis.opendocument.spreadsheet");
        mimeMap.put("txt", "text/plain");
        mimeMap.put("log", "text/plain");
    }

    public static class PageFetcherResult {
        int httpStatus = 200;
        String contentType = "text/html";
        URL redirectUrl = null;
        ByteBuffer content;
    }

    class PageFetcher {
        Map<String, List<String>> robotsCache = new HashMap<String, List<String>>();
        static final String DISALLOW = "Disallow:";

        public PageFetcherResult readPageFromUrl(URL u) throws URISyntaxException {
            PageFetcherResult res = new PageFetcherResult();
            try {
                if (this.isDisallowedByRobots(u)) {
                    SimplePostTool.warn("The URL " + u + " is disallowed by robots.txt and will not be crawled.");
                    res.httpStatus = 403;
                    URI uri = u.toURI();
                    SimplePostTool.this.visited.add(uri);
                    return res;
                }
                res.httpStatus = 404;
                HttpURLConnection conn = (HttpURLConnection)u.openConnection();
                conn.setRequestProperty("User-Agent", "SimplePostTool-crawler/9.6.0 (https://solr.apache.org/)");
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.connect();
                res.httpStatus = conn.getResponseCode();
                if (!SimplePostTool.normalizeUrlEnding(conn.getURL().toString()).equals(SimplePostTool.normalizeUrlEnding(u.toString()))) {
                    SimplePostTool.info("The URL " + u + " caused a redirect to " + conn.getURL());
                    res.redirectUrl = u = conn.getURL();
                    URI uri = u.toURI();
                    SimplePostTool.this.visited.add(uri);
                }
                if (res.httpStatus == 200) {
                    String rawContentType = conn.getContentType();
                    String type = rawContentType.split(";")[0];
                    if (SimplePostTool.this.typeSupported(type) || "*".equals(SimplePostTool.this.fileTypes)) {
                        String encoding = conn.getContentEncoding();
                        InputStream is = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && encoding.equalsIgnoreCase("deflate") ? new InflaterInputStream(conn.getInputStream(), new Inflater(true)) : conn.getInputStream());
                        res.content = Utils.toByteArray((InputStream)is);
                        is.close();
                    } else {
                        SimplePostTool.warn("Skipping URL with unsupported type " + type);
                        res.httpStatus = 415;
                    }
                }
            }
            catch (IOException e) {
                SimplePostTool.warn("IOException when reading page from url " + u + ": " + e.getMessage());
            }
            return res;
        }

        public boolean isDisallowedByRobots(URL url) {
            String host = url.getHost();
            String strRobot = url.getProtocol() + "://" + host + "/robots.txt";
            List<String> disallows = this.robotsCache.get(host);
            if (disallows == null) {
                disallows = new ArrayList<String>();
                try {
                    URL urlRobot = new URL(strRobot);
                    disallows = this.parseRobotsTxt(urlRobot.openStream());
                }
                catch (MalformedURLException e) {
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.robotsCache.put(host, disallows);
            String strURL = url.getFile();
            for (String path : disallows) {
                if (!path.equals("/") && strURL.indexOf(path) != 0) continue;
                return true;
            }
            return false;
        }

        protected List<String> parseRobotsTxt(InputStream is) throws IOException {
            String l;
            ArrayList<String> disallows = new ArrayList<String>();
            BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((l = r.readLine()) != null) {
                String[] arr = l.split("#");
                if (arr.length == 0 || !(l = arr[0].trim()).startsWith(DISALLOW) || (l = l.substring(DISALLOW.length()).trim()).length() == 0) continue;
                disallows.add(l);
            }
            is.close();
            return disallows;
        }

        protected Set<URI> getLinksFromWebPage(URL u, InputStream is, String type, URL postUrl) {
            HashSet<URI> linksFromPage = new HashSet<URI>();
            URL url = null;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                URL extractUrl = new URL(SimplePostTool.appendParam(postUrl.toString(), "extractOnly=true"));
                extractUrl = new URL(SimplePostTool.appendParam(extractUrl.toString(), "wt=xml"));
                boolean success = SimplePostTool.this.postData(is, null, os, type, extractUrl);
                if (success) {
                    Document d = SimplePostTool.makeDom(os.toByteArray());
                    String innerXml = SimplePostTool.getXP(d, "/response/str/text()[1]", false);
                    d = SimplePostTool.makeDom(innerXml.getBytes(StandardCharsets.UTF_8));
                    NodeList links = SimplePostTool.getNodesFromXP(d, "/html/body//a/@href");
                    for (int i = 0; i < links.getLength(); ++i) {
                        URI newUri;
                        String link = links.item(i).getTextContent();
                        if ((link = SimplePostTool.this.computeFullUrl(u, link)) == null || (newUri = new URI(link)).getAuthority() != null && newUri.getAuthority().equals(u.getAuthority())) continue;
                        linksFromPage.add(newUri);
                    }
                }
            }
            catch (MalformedURLException e) {
                SimplePostTool.warn("Malformed URL " + url);
            }
            catch (IOException e) {
                SimplePostTool.warn("IOException opening URL " + url + ": " + e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return linksFromPage;
        }
    }

    static class GlobFileFilter
    implements FileFilter {
        private String _pattern;
        private Pattern p;

        public GlobFileFilter(String pattern, boolean isRegex) {
            this._pattern = pattern;
            if (!isRegex) {
                this._pattern = this._pattern.replace("^", "\\^").replace("$", "\\$").replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("+", "\\+").replace("*", ".*").replace("?", ".");
                this._pattern = "^" + this._pattern + "$";
            }
            try {
                this.p = Pattern.compile(this._pattern, 2);
            }
            catch (PatternSyntaxException e) {
                SimplePostTool.fatal("Invalid type list " + pattern + ". " + e.getDescription());
            }
        }

        @Override
        public boolean accept(File file) {
            return this.p.matcher(file.getName()).find();
        }
    }
}

