/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.SafeXMLParsing;
import org.apache.tika.parser.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParseContextConfig {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<Class<?>, Object> entries = new HashMap();

    public ParseContextConfig() {
    }

    public ParseContextConfig(SolrResourceLoader resourceLoader, Element element) throws Exception {
        this.extract(element, resourceLoader);
    }

    public ParseContextConfig(SolrResourceLoader resourceLoader, String parseContextConfigLoc) throws Exception {
        this(resourceLoader, ParseContextConfig.loadConfigFile(resourceLoader, parseContextConfigLoc).getDocumentElement());
    }

    private static Document loadConfigFile(SolrResourceLoader resourceLoader, String parseContextConfigLoc) throws Exception {
        return SafeXMLParsing.parseConfigXML((Logger)log, (ResourceLoader)resourceLoader, (String)parseContextConfigLoc);
    }

    private void extract(Element element, SolrResourceLoader loader) throws Exception {
        NodeList xmlEntries = element.getElementsByTagName("entry");
        int c1 = xmlEntries.getLength();
        for (int i = 0; i < c1; ++i) {
            NamedNodeMap xmlEntryAttributes = xmlEntries.item(i).getAttributes();
            String className = xmlEntryAttributes.getNamedItem("class").getNodeValue();
            String implementationName = xmlEntryAttributes.getNamedItem("impl").getNodeValue();
            NodeList xmlProperties = ((Element)xmlEntries.item(i)).getElementsByTagName("property");
            Class interfaceClass = loader.findClass(className, Object.class);
            BeanInfo beanInfo = Introspector.getBeanInfo(interfaceClass, 3);
            HashMap<String, PropertyDescriptor> descriptorMap = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                descriptorMap.put(pd.getName(), pd);
            }
            Object instance = loader.newInstance(implementationName, Object.class);
            if (!interfaceClass.isInstance(instance)) {
                throw new IllegalArgumentException("Implementation class does not extend " + interfaceClass.getName());
            }
            int c2 = xmlProperties.getLength();
            for (int j = 0; j < c2; ++j) {
                Node xmlProperty = xmlProperties.item(j);
                NamedNodeMap xmlPropertyAttributes = xmlProperty.getAttributes();
                String propertyName = xmlPropertyAttributes.getNamedItem("name").getNodeValue();
                String propertyValue = xmlPropertyAttributes.getNamedItem("value").getNodeValue();
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptorMap.get(propertyName);
                if (propertyDescriptor == null) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown bean property %s in class %s", propertyName, interfaceClass.getName()));
                }
                Method method = propertyDescriptor.getWriteMethod();
                if (method == null) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot set bean property %s in class %s (no write method available)", propertyName, interfaceClass.getName()));
                }
                method.invoke(instance, this.getValueFromString(propertyDescriptor.getPropertyType(), propertyValue));
            }
            this.entries.put(interfaceClass, instance);
        }
    }

    private Object getValueFromString(Class<?> targetType, String text) {
        PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
        if (editor == null) {
            throw new IllegalArgumentException("Cannot set properties of type " + targetType.getName());
        }
        editor.setAsText(text);
        return editor.getValue();
    }

    public ParseContext create() {
        ParseContext result = new ParseContext();
        for (Map.Entry<Class<?>, Object> entry : this.entries.entrySet()) {
            result.set(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

