/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import de.justsoftware.people.config.ConfigService;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.ConfigRepository;
import de.justsoftware.people.persistence.model.DbConfig;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/people/config/ConfigService;", "", "configRepository", "Lde/justsoftware/people/persistence/ConfigRepository;", "(Lde/justsoftware/people/persistence/ConfigRepository;)V", "isBirthdayListEnabled", "", "tenantId", "Lde/justsoftware/people/model/TenantId;", "setBirthdayListEnabled", "", "enabled", "people-api"})
public class ConfigService {
    @NotNull
    private final ConfigRepository configRepository;

    public ConfigService(@NotNull ConfigRepository configRepository) {
        Intrinsics.checkNotNullParameter((Object)configRepository, (String)"configRepository");
        this.configRepository = configRepository;
    }

    public boolean isBirthdayListEnabled(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Boolean bl = this.configRepository.findById(tenantId.getId()).map(arg_0 -> ConfigService.isBirthdayListEnabled$lambda$0((Function1)isBirthdayListEnabled.1.INSTANCE, arg_0)).orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        return bl;
    }

    public void setBirthdayListEnabled(@NotNull TenantId tenantId, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.configRepository.save((Object)new DbConfig((UUID)tenantId.getId(), enabled));
    }

    private static final Boolean isBirthdayListEnabled$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

