/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupCreatedOrPublishedEvent;
import de.justsoftware.people.business.event.UserGroupDeletedEvent;
import de.justsoftware.people.business.event.UserGroupMembersUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupRolesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupUpdatedEvent;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchField;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchId;
import de.justsoftware.people.business.search.solr.SolrIntegration;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.business.search.solr.model.UserGroupSearchIndexModel;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0017\u0018\u0000 Z2\u00020\u0001:\u0001ZBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0014\b\u0001\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J`\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J>\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J<\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J \u00101\u001a\u0004\u0018\u00010\u001c2\u0006\u00102\u001a\u0002032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u0014042\u0006\u00105\u001a\u00020\u0018H\u0016J\u0015\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0011\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020<H\u0011\u00a2\u0006\u0002\b=J!\u0010>\u001a\u0002072\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\u00100@H\u0011\u00a2\u0006\u0002\bBJ\u0015\u0010C\u001a\u0002072\u0006\u00108\u001a\u00020DH\u0011\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u0002072\u0006\u00108\u001a\u00020GH\u0011\u00a2\u0006\u0002\bHJ\u0015\u0010I\u001a\u0002072\u0006\u00108\u001a\u00020JH\u0011\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u0002072\u0006\u00108\u001a\u00020MH\u0011\u00a2\u0006\u0002\bNJ\u0015\u0010O\u001a\u0002072\u0006\u00108\u001a\u00020PH\u0011\u00a2\u0006\u0002\bQJ\u0010\u0010R\u001a\u0002072\u0006\u0010S\u001a\u000203H\u0012J\u0016\u0010R\u001a\u0002072\f\u0010T\u001a\b\u0012\u0004\u0012\u0002030UH\u0012J\u0010\u0010V\u001a\u0002072\u0006\u0010S\u001a\u00020AH\u0012J\u0016\u0010V\u001a\u0002072\f\u0010T\u001a\b\u0012\u0004\u0012\u00020A0UH\u0012J\b\u0010W\u001a\u000207H\u0016JJ\u0010X\u001a\b\u0012\u0004\u0012\u00020-0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lde/justsoftware/people/business/search/SearchService;", "", "solrIntegration", "Lde/justsoftware/people/business/search/solr/SolrIntegration;", "profileAttributeConfigService", "Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "visibilityService", "Lde/justsoftware/people/business/search/VisibilityService;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "(Lde/justsoftware/people/business/search/solr/SolrIntegration;Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;Lde/justsoftware/people/business/profile/ProfileService;Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/business/search/VisibilityService;Lde/justsoftware/search/shared/SolrIndexQueue;Lde/justsoftware/kafka/client/KafkaCleaningProducer;)V", "searchConfiguration", "", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfig;", "getSearchConfiguration", "()Ljava/util/List;", "searchableFields", "Lde/justsoftware/people/business/search/model/SearchField;", "getSearchableFields", "allProfiles", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "searchString", "searchFilter", "Lde/justsoftware/people/business/search/model/SearchFilter;", "searchRoles", "", "Lde/justsoftware/permission/client/model/Role;", "facetFilter", "Lde/justsoftware/people/business/search/model/FacetFilter;", "groupId", "Lde/justsoftware/people/model/UserGroupId;", "offset", "", "limit", "allProfilesAndUserGroups", "Lde/justsoftware/people/business/search/solr/model/SearchModel;", "birthdayList", "currentDate", "Ljava/time/LocalDate;", "findProfile", "profileId", "Lde/justsoftware/people/model/ProfileId;", "Ljava/util/Optional;", "searchField", "onProfilesDeletedEvent", "", "e", "Lde/justsoftware/people/business/event/ProfilesDeletedEvent;", "onProfilesDeletedEvent$people_api", "onProfilesUpdatedEvent", "Lde/justsoftware/people/business/event/ProfilesUpdatedEvent;", "onProfilesUpdatedEvent$people_api", "onSearchIndex", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/business/search/model/SearchId;", "onSearchIndex$people_api", "onUserGroupCreatedOrPublishedEvent", "Lde/justsoftware/people/business/event/UserGroupCreatedOrPublishedEvent;", "onUserGroupCreatedOrPublishedEvent$people_api", "onUserGroupDeletedEvent", "Lde/justsoftware/people/business/event/UserGroupDeletedEvent;", "onUserGroupDeletedEvent$people_api", "onUserGroupMembersUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupMembersUpdatedEvent;", "onUserGroupMembersUpdatedEvent$people_api", "onUserGroupRolesUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupRolesUpdatedEvent;", "onUserGroupRolesUpdatedEvent$people_api", "onUserGroupUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupUpdatedEvent;", "onUserGroupUpdatedEvent$people_api", "queueReindexInCommonCore", "searchId", "searchIds", "", "queueReindexInPeopleCore", "reindexAllGroups", "searchInNames", "types", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/people/business/search/SearchService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n17#2:304\n1620#3,3:305\n800#3,11:308\n800#3,11:319\n1549#3:330\n1620#3,3:331\n1549#3:334\n1620#3,3:335\n1855#3,2:338\n1855#3,2:340\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/people/business/search/SearchService\n*L\n187#1:304\n187#1:305,3\n188#1:308,11\n189#1:319,11\n195#1:330\n195#1:331,3\n201#1:334\n201#1:335,3\n264#1:338,2\n277#1:340,2\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrIntegration solrIntegration;
    @NotNull
    private final ProfileAttributeConfigService profileAttributeConfigService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final VisibilityService visibilityService;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    public static final String PEOPLE_SEARCH_INDEX_TOPIC = "just.people.search.index";
    @NotNull
    public static final String COMMON_VISIBILITY_SEARCH_INDEX_TOPIC = "just.search.index.visibilities";
    @NotNull
    public static final String SEARCH_INDEX_LISTENER_ID = "SearchIndexConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);

    public SearchService(@NotNull SolrIntegration solrIntegration, @NotNull ProfileAttributeConfigService profileAttributeConfigService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull VisibilityService visibilityService, @NotNull SolrIndexQueue solrIndexQueue, @Qualifier(value="KAFKA_STRING_PRODUCER") @NotNull KafkaCleaningProducer<String, String> kafkaProducer) {
        Intrinsics.checkNotNullParameter((Object)solrIntegration, (String)"solrIntegration");
        Intrinsics.checkNotNullParameter((Object)profileAttributeConfigService, (String)"profileAttributeConfigService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)visibilityService, (String)"visibilityService");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        this.solrIntegration = solrIntegration;
        this.profileAttributeConfigService = profileAttributeConfigService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.visibilityService = visibilityService;
        this.solrIndexQueue = solrIndexQueue;
        this.kafkaProducer = kafkaProducer;
    }

    @NotNull
    public PagedResult<ProfileSearchReadModel> allProfiles(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull List<? extends SearchFilter> searchFilter, @NotNull Set<Role> searchRoles, @Nullable FacetFilter facetFilter, @Nullable UserGroupId groupId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchFilter, (String)"searchFilter");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.allProfiles(tenantId, searchString, searchFilter, searchRoles, facetFilter, groupId, offset, limit);
    }

    @NotNull
    public PagedResult<ProfileSearchReadModel> birthdayList(@NotNull TenantId tenantId, @NotNull LocalDate currentDate, @NotNull Set<Role> searchRoles, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.birthdayList(tenantId, currentDate, searchRoles, offset, limit);
    }

    @NotNull
    public PagedResult<SearchModel> allProfilesAndUserGroups(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.allProfilesAndUserGroups(tenantId, searchString, searchRoles, offset, limit);
    }

    @Nullable
    public ProfileSearchReadModel findProfile(@NotNull ProfileId profileId, @NotNull Set<Role> searchRoles) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.findProfile(profileId, searchRoles);
    }

    @NotNull
    public PagedResult<SearchModel> searchInNames(@NotNull TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, @NotNull Set<String> types, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        return this.solrIntegration.searchInNames(tenantId, searchString, searchRoles, types, offset, limit);
    }

    @NotNull
    public List<SearchField> getSearchableFields() {
        return this.profileAttributeConfigService.searchFields();
    }

    @NotNull
    public List<ProfileAttributeConfig> getSearchConfiguration() {
        return CollectionsKt.toList((Iterable)this.profileAttributeConfigService.getConfiguration().values());
    }

    @NotNull
    public Optional<ProfileAttributeConfig> getSearchConfiguration(@NotNull SearchField searchField) {
        Intrinsics.checkNotNullParameter((Object)searchField, (String)"searchField");
        return this.profileAttributeConfigService.configFor(searchField);
    }

    public void reindexAllGroups() {
        this.solrIntegration.deleteAllUserGroups();
        this.userGroupService.forAllUserGroups(arg_0 -> SearchService.reindexAllGroups$lambda$0(this, arg_0));
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)SetsKt.setOf((Object)SearchType.USER_GROUP), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="SearchIndexConsumer", containerFactory="searchIndexQueueConsumerFactory", topics={"just.people.search.index"}, idIsGroup=false)
    public void onSearchIndex$people_api(@NotNull ConsumerRecords<SearchId, String> records) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        LOG.debug("Update Solr for {} records", (Object)records.count());
        Iterable $this$mapToSet$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchId)p0.key());
        }
        Set searchIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = searchIds;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set profileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filterIsInstance$iv2 = searchIds;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set userGroupIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Map visibilities = this.visibilityService.visibilities(searchIds);
        Map profiles = this.profileService.findUndeletedProfileByIds((Iterable)profileIds);
        Map profileUserGroupIds = this.userGroupService.getUserGroupsForProfiles(profiles.keySet());
        Map userGroups = this.userGroupService.findAllByIds(userGroupIds);
        Set deletedSearchIds = SetsKt.minus((Set)SetsKt.minus((Set)searchIds, (Iterable)profiles.keySet()), (Iterable)userGroups.keySet());
        Iterable $this$map$iv = profiles.values();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Profile profile = (Profile)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            List list = (List)profileUserGroupIds.get(it.getId());
            Collection collection2 = (Collection)visibilities.get(it.getId());
            collection.add(Profile.Companion.toProfileSearchIndexModel((Profile)it, list != null ? CollectionsKt.toSet((Iterable)list) : null, collection2 != null ? CollectionsKt.toSet((Iterable)collection2) : null));
        }
        List profileSearchIndexModels = (List)destination$iv$iv4;
        Iterable $this$map$iv2 = userGroups.values();
        boolean $i$f$map2 = false;
        destination$iv$iv4 = $this$map$iv2;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroup bl = (UserGroup)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl2 = false;
            UserGroupId userGroupId = it.getId();
            String string = it.getName();
            TenantId tenantId = it.getTenantId();
            boolean bl3 = it.isImported();
            boolean bl4 = it.isAllTenantUsers();
            Collection collection3 = (Collection)visibilities.get(it.getId());
            if (collection3 == null || (collection3 = CollectionsKt.toSet((Iterable)collection3)) == null) {
                collection3 = SetsKt.emptySet();
            }
            collection.add(new UserGroupSearchIndexModel(userGroupId, string, tenantId, bl3, bl4, (Set)collection3));
        }
        List userGroupSearchIndexModel = (List)destination$iv$iv5;
        this.solrIntegration.delete(deletedSearchIds);
        this.solrIntegration.index((Iterable)CollectionsKt.plus((Collection)profileSearchIndexModels, (Iterable)userGroupSearchIndexModel));
        Object[] objectArray = new Object[]{profileSearchIndexModels.size(), userGroupSearchIndexModel.size(), deletedSearchIds.size()};
        LOG.info("Updating Solr with {} profiles and {} groups. Deleting {} profiles and groups.", objectArray);
    }

    @EventListener
    public void onProfilesUpdatedEvent$people_api(@NotNull ProfilesUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)e.getUpdatedProfiles());
    }

    @EventListener
    public void onProfilesDeletedEvent$people_api(@NotNull ProfilesDeletedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)e.getProfileIds());
    }

    @EventListener
    public void onUserGroupCreatedOrPublishedEvent$people_api(@NotNull UserGroupCreatedOrPublishedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((SearchId)e.getUserGroupId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)e.getUserGroupId().toSearchableId()));
    }

    @EventListener
    public void onUserGroupUpdatedEvent$people_api(@NotNull UserGroupUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((SearchId)e.getUserGroupId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)e.getUserGroupId().toSearchableId()));
    }

    @EventListener
    public void onUserGroupDeletedEvent$people_api(@NotNull UserGroupDeletedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)SetsKt.plus((Set)SetsKt.setOf((Object)e.getUserGroupId()), (Iterable)e.getGroupMembers()));
        this.queueReindexInCommonCore((Collection)e.getGroupMembers());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)e.getUserGroupId().toSearchableId()));
    }

    @EventListener
    public void onUserGroupMembersUpdatedEvent$people_api(@NotNull UserGroupMembersUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.setOf((Object)e.getUserGroupId()), (Iterable)e.getAddedMembers()), (Iterable)e.getDeletedMembers()));
        this.queueReindexInCommonCore((Collection)SetsKt.plus((Set)e.getAddedMembers(), (Iterable)e.getDeletedMembers()));
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)e.getUserGroupId().toSearchableId()));
    }

    @EventListener
    public void onUserGroupRolesUpdatedEvent$people_api(@NotNull UserGroupRolesUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)SetsKt.plus((Set)SetsKt.setOf((Object)e.getUserGroupId()), (Iterable)e.getGroupMembers()));
        this.queueReindexInCommonCore((Collection)e.getGroupMembers());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)e.getUserGroupId().toSearchableId()));
    }

    private void queueReindexInPeopleCore(Collection<? extends SearchId> searchIds) {
        Iterable $this$forEach$iv = searchIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchId p0 = (SearchId)element$iv;
            boolean bl = false;
            this.queueReindexInPeopleCore(p0);
        }
    }

    private void queueReindexInPeopleCore(SearchId searchId) {
        this.kafkaProducer.send(new ProducerRecord("just.people.search.index", (Object)searchId.toCanonicalId(), (Object)""), SearchService::queueReindexInPeopleCore$lambda$4);
    }

    private void queueReindexInCommonCore(Collection<ProfileId> searchIds) {
        Iterable $this$forEach$iv = searchIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProfileId p0 = (ProfileId)element$iv;
            boolean bl = false;
            this.queueReindexInCommonCore(p0);
        }
    }

    private void queueReindexInCommonCore(ProfileId searchId) {
        this.kafkaProducer.send(new ProducerRecord("just.search.index.visibilities", (Object)searchId.toCanonicalId(), (Object)""), SearchService::queueReindexInCommonCore$lambda$6);
    }

    private static final void reindexAllGroups$lambda$0(SearchService this$0, UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this$0.queueReindexInPeopleCore((SearchId)userGroup.getId());
    }

    private static final void queueReindexInPeopleCore$lambda$4(RecordMetadata metadata, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Companion.access$logErrorCallback((Companion)Companion, (RecordMetadata)metadata, (Exception)exception);
    }

    private static final void queueReindexInCommonCore$lambda$6(RecordMetadata metadata, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Companion.access$logErrorCallback((Companion)Companion, (RecordMetadata)metadata, (Exception)exception);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

