/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import de.justsoftware.people.business.notification.NotificationService;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.BirthdayReminderRepository;
import de.justsoftware.people.persistence.ProfileRepository;
import de.justsoftware.people.persistence.model.DbBirthdayReminder;
import de.justsoftware.people.persistence.model.DbProfile;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.JustPermissionRequestConnector;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/people/business/profile/BirthdayReminderService;", "", "birthdayReminderRepository", "Lde/justsoftware/people/persistence/BirthdayReminderRepository;", "profileRepository", "Lde/justsoftware/people/persistence/ProfileRepository;", "notificationService", "Lde/justsoftware/people/business/notification/NotificationService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/JustPermissionRequestConnector;", "(Lde/justsoftware/people/persistence/BirthdayReminderRepository;Lde/justsoftware/people/persistence/ProfileRepository;Lde/justsoftware/people/business/notification/NotificationService;Lde/justsoftware/permission/client/rest/JustPermissionRequestConnector;)V", "sendBirthdayNotifications", "", "getFullName", "", "Lde/justsoftware/people/persistence/model/DbProfile;", "people-api"})
@SourceDebugExtension(value={"SMAP\nBirthdayReminderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BirthdayReminderService.kt\nde/justsoftware/people/business/profile/BirthdayReminderService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/people/utils/LoggerUtilsKt\n*L\n1#1,77:1\n1360#2:78\n1446#2,2:79\n1549#2:81\n1620#2,3:82\n1448#2,3:85\n766#2:88\n857#2,2:89\n1549#2:91\n1620#2,3:92\n766#2:95\n857#2,2:96\n8#3:98\n7#3,3:99\n*S KotlinDebug\n*F\n+ 1 BirthdayReminderService.kt\nde/justsoftware/people/business/profile/BirthdayReminderService\n*L\n36#1:78\n36#1:79,2\n36#1:81\n36#1:82,3\n36#1:85,3\n47#1:88\n47#1:89,2\n48#1:91\n48#1:92,3\n49#1:95\n49#1:96,2\n59#1:98\n59#1:99,3\n*E\n"})
public class BirthdayReminderService {
    @NotNull
    private final BirthdayReminderRepository birthdayReminderRepository;
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final NotificationService notificationService;
    @NotNull
    private final JustPermissionRequestConnector permissionRequestConnector;

    public BirthdayReminderService(@NotNull BirthdayReminderRepository birthdayReminderRepository, @NotNull ProfileRepository profileRepository, @NotNull NotificationService notificationService, @NotNull JustPermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)birthdayReminderRepository, (String)"birthdayReminderRepository");
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.birthdayReminderRepository = birthdayReminderRepository;
        this.profileRepository = profileRepository;
        this.notificationService = notificationService;
        this.permissionRequestConnector = permissionRequestConnector;
    }

    /*
     * WARNING - void declaration
     */
    public void sendBirthdayNotifications() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        LocalDate today = LocalDate.now();
        List birthdayProfiles = this.profileRepository.findProfilesByBirthday(today.getMonthValue(), today.getDayOfMonth());
        if (birthdayProfiles.isEmpty()) {
            return;
        }
        Iterable iterable = CollectionsKt.chunked((Iterable)birthdayProfiles, (int)1000);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterator iterator = it;
            BirthdayReminderRepository birthdayReminderRepository = this.birthdayReminderRepository;
            boolean $i$f$map = false;
            void var16_21 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DbProfile dbProfile = (DbProfile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.getId());
            }
            Iterable list$iv$iv = birthdayReminderRepository.findByReminderProfileIdIn((Iterable)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List subscribedReminderProfileIds = (List)destination$iv$iv;
        for (DbProfile profile : birthdayProfiles) {
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object element$iv$iv;
            if (profile.getTenantId() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)Role.read((String)new ProfileId(profile.getId()).asString()), (String)"read(...)");
            Iterable $i$f$flatMapTo2 = subscribedReminderProfileIds;
            ProfileId.Companion companion = ProfileId.Companion;
            boolean $i$f$filter = false;
            element$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                DbBirthdayReminder it = (DbBirthdayReminder)element$iv$iv2;
                boolean bl = false;
                if (!(it.getReminderProfileId() == profile.getId())) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DbBirthdayReminder it = (DbBirthdayReminder)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(it.getProfileId());
            }
            $this$map$iv = (List)destination$iv$iv3;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Role profileReadRole;
                long it = ((Number)element$iv$iv2).longValue();
                boolean bl = false;
                boolean bl3 = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)profileReadRole), (Iterable)SetsKt.setOf((Object)new ProfileId(it).asPermissionRole())).get((Object)profileReadRole) == AuthorizationResult.OK;
                if (!bl3) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            Set profileIdsToNotify = companion.toProfileIds((Iterable)((List)destination$iv$iv3));
            if (!(!((Collection)profileIdsToNotify).isEmpty())) continue;
            BirthdayReminderService $this$logger$iv = this;
            boolean $i$f$logger = false;
            Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(BirthdayReminderService.class).isCompanion() ? BirthdayReminderService.class.getEnclosingClass() : BirthdayReminderService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Sending birthday notifications for profile " + profile.getId() + " to " + profileIdsToNotify.size() + " people.");
            this.notificationService.sendBirthdayNotifications(new TenantId(profile.getTenantId()), new ProfileId(profile.getId()), profile.getFirstName(), this.getFullName(profile), profileIdsToNotify);
        }
    }

    private String getFullName(DbProfile $this$getFullName) {
        CharSequence charSequence;
        String string = $this$getFullName.getTitle();
        if (string == null) {
            string = "";
        }
        return ((Object)StringsKt.trim((CharSequence)(string + " " + $this$getFullName.getFirstName() + " " + $this$getFullName.getLastName() + (String)(!((charSequence = (CharSequence)$this$getFullName.getAdditionalTitle()) == null || StringsKt.isBlank((CharSequence)charSequence)) ? ", " + $this$getFullName.getAdditionalTitle() : "")))).toString();
    }
}

