/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application;

import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.permission.client.model.Role;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/people/application/ProfileApplicationService;", "", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "(Lde/justsoftware/people/business/profile/ProfileService;)V", "deleteBirthdayReminderForProfile", "", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "reminderProfileId", "Lde/justsoftware/people/model/ProfileId;", "saveBirthdayReminderForProfile", "people-api"})
public class ProfileApplicationService {
    @NotNull
    private final ProfileService profileService;

    public ProfileApplicationService(@NotNull ProfileService profileService) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        this.profileService = profileService;
    }

    public void saveBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        authCtx.check(Role.read((String)reminderProfileId.toString()));
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        this.profileService.saveBirthdayReminder(profileId, reminderProfileId);
    }

    public void deleteBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        authCtx.check(Role.read((String)reminderProfileId.toString()));
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        this.profileService.deleteBirthdayReminder(profileId, reminderProfileId);
    }
}

