/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.controller;

import de.justsoftware.search.authorization.AuthorizationContext;
import de.justsoftware.search.business.SearchService;
import de.justsoftware.search.business.model.SearchResult;
import de.justsoftware.search.business.model.SolrSearchResultDto;
import de.justsoftware.search.business.model.SortBy;
import de.justsoftware.search.business.model.SortDirection;
import de.justsoftware.search.shared.model.JustApp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/search"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JT\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/search/controller/SearchController;", "", "searchService", "Lde/justsoftware/search/business/SearchService;", "(Lde/justsoftware/search/business/SearchService;)V", "search", "Lde/justsoftware/search/business/model/SearchResult;", "Lde/justsoftware/search/business/model/SolrSearchResultDto;", "query", "", "offset", "", "count", "app", "Lde/justsoftware/search/shared/model/JustApp;", "sortBy", "Lde/justsoftware/search/business/model/SortBy;", "sortDirection", "Lde/justsoftware/search/business/model/SortDirection;", "authContext", "Lde/justsoftware/search/authorization/AuthorizationContext;", "search-service"})
public class SearchController {
    @NotNull
    private final SearchService searchService;

    public SearchController(@NotNull SearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        this.searchService = searchService;
    }

    @GetMapping
    @NotNull
    public SearchResult<SolrSearchResultDto> search(@RequestParam(value="query", required=false, defaultValue="") @NotNull String query, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="count", required=false, defaultValue="50") int count, @RequestParam(value="app", required=false) @Nullable JustApp app, @RequestParam(value="sortBy", required=false, defaultValue="SCORE") @NotNull SortBy sortBy, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") @NotNull SortDirection sortDirection, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.searchService.search(authContext, query, offset, count, app, sortBy, sortDirection);
    }
}

