/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.business;

import de.justsoftware.search.authorization.AuthorizationContext;
import de.justsoftware.search.business.PermissionService;
import de.justsoftware.search.business.SearchService;
import de.justsoftware.search.business.model.SearchResult;
import de.justsoftware.search.business.model.SolrSearchResult;
import de.justsoftware.search.business.model.SolrSearchResultDto;
import de.justsoftware.search.business.model.SortBy;
import de.justsoftware.search.business.model.SortDirection;
import de.justsoftware.search.model.JustSocialSolrCoreSearchFields;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.search.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006Ji\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0019\b\u0002\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0012J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0012JH\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0012Jo\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0019\b\u0002\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/search/business/SearchService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "permissionService", "Lde/justsoftware/search/business/PermissionService;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/search/business/PermissionService;)V", "buildSolrQuery", "Lorg/apache/solr/client/solrj/SolrQuery;", "query", "", "apps", "", "Lde/justsoftware/search/shared/model/JustApp;", "sortBy", "Lde/justsoftware/search/business/model/SortBy;", "sortDirection", "Lde/justsoftware/search/business/model/SortDirection;", "profileId", "Lde/justsoftware/search/shared/model/ProfileId;", "tenantId", "Lde/justsoftware/search/shared/model/TenantId;", "offset", "", "count", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "buildSolrQueryForNames", "search", "Lde/justsoftware/search/business/model/SearchResult;", "Lde/justsoftware/search/business/model/SolrSearchResultDto;", "authContext", "Lde/justsoftware/search/authorization/AuthorizationContext;", "app", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "sendSolrQuery", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n+ 2 CollectionUtils.kt\nde/justsoftware/search/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,164:1\n10#2:165\n1611#3:166\n1855#3:167\n1856#3:170\n1612#3:171\n1179#3,2:172\n1253#3,4:174\n2634#3:178\n1549#3:180\n1620#3,3:181\n1#4:168\n1#4:169\n1#4:179\n8#5:184\n7#5,3:185\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n*L\n79#1:165\n79#1:166\n79#1:167\n79#1:170\n79#1:171\n86#1:172,2\n86#1:174,4\n91#1:178\n99#1:180\n99#1:181,3\n79#1:169\n91#1:179\n151#1:184\n151#1:185,3\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REQUESTED_FIELDS;
    @NotNull
    private static final String REQUESTED_FIELDS_FOR_NAME;

    public SearchService(@Qualifier(value="justSocialCoreLeaderSolrClient") @NotNull SolrClient solrClient, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        this.solrClient = solrClient;
        this.permissionService = permissionService;
    }

    @NotNull
    public SearchResult<SolrSearchResultDto> search(@NotNull AuthorizationContext authContext, @NotNull String query, int offset, int count, @Nullable JustApp app, @NotNull SortBy sortBy, @NotNull SortDirection sortDirection) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        JustApp justApp = app;
        List list = justApp != null ? CollectionsKt.listOf((Object)justApp) : CollectionsKt.emptyList();
        ProfileId profileId = authContext.getProfileId();
        TenantId tenantId = authContext.getTenantId();
        return SearchService.sendSolrQuery$default((SearchService)this, (String)query, (List)list, (SortBy)sortBy, (SortDirection)sortDirection, (ProfileId)profileId, (TenantId)tenantId, (int)offset, (int)count, null, (int)256, null);
    }

    /*
     * WARNING - void declaration
     */
    private SearchResult<SolrSearchResultDto> sendSolrQuery(String query, List<? extends JustApp> apps, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int offset, int count, Function1<? super SolrQuery, Unit> configure) {
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrSearchResult result;
        Iterable $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        QueryResponse searchQueryResponse = this.send(this.buildSolrQuery(query, apps, sortBy, sortDirection, profileId, tenantId, offset, count, configure));
        List searchResults = searchQueryResponse.getBeans(SolrSearchResult.class);
        Intrinsics.checkNotNull((Object)searchResults);
        Iterable $this$mapNotNullToSet$iv = searchResults;
        boolean $i$f$mapNotNullToSet22 = false;
        Iterable iterable = $this$mapNotNullToSet$iv;
        String[] destination$iv$iv = (String[])new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            String it$iv$iv;
            CharSequence charSequence;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            SolrSearchResult it = (SolrSearchResult)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = it.getParentId();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            if ((String)charSequence == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set parentIds = (Set)destination$iv$iv;
        destination$iv$iv = new String[]{CollectionsKt.joinToString$default((Iterable)parentIds, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)sendSolrQuery.parentNames.1.INSTANCE), (int)30, null)};
        SolrQuery solrQuery = this.buildSolrQueryForNames(count).addFilterQuery(destination$iv$iv).setHighlight(false);
        Intrinsics.checkNotNullExpressionValue((Object)solrQuery, (String)"setHighlight(...)");
        Iterable $i$f$mapNotNullToSet22 = this.send(solrQuery).getBeans(SolrSearchResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNullToSet22, (String)"getBeans(...)");
        $i$f$mapNotNullToSet22 = $i$f$mapNotNullToSet22;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void $i$f$mapNotNullTo22 = $this$associate$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            element$iv$iv = destination$iv$iv2;
            SolrSearchResult it = (SolrSearchResult)element$iv$iv2;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getId(), (Object)it.getName());
            element$iv$iv.put((Object)it.getFirst(), (Object)it.getSecond());
        }
        Map parentNames2 = destination$iv$iv2;
        Map map = searchQueryResponse.getHighlighting();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map highlighting = map;
        Iterable $this$onEach$iv = searchResults;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = $this$associateTo$iv$iv = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            result = (SolrSearchResult)element$iv;
            boolean bl5 = false;
            Map map2 = (Map)highlighting.get(result.getId());
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            result.setHighlightedFields(map2);
        }
        $this$onEach$iv = searchResults;
        int n = 0;
        int n2 = offset;
        boolean $i$f$map = false;
        $this$associateTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            result = (SolrSearchResult)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it);
            object.add(SolrSearchResultDto.Companion.toDto((SolrSearchResult)it, parentNames2.getOrDefault(it.getParentId(), "")));
        }
        object = (List)destination$iv$iv2;
        List list = object;
        int n3 = n;
        int n4 = n2;
        return new SearchResult(n4, n3, list);
    }

    static /* synthetic */ SearchResult sendSolrQuery$default(SearchService searchService, String string, List list, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int n, int n2, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendSolrQuery");
        }
        if ((n3 & 0x100) != 0) {
            function1 = (Function1)sendSolrQuery.1.INSTANCE;
        }
        return searchService.sendSolrQuery(string, list, sortBy, sortDirection, profileId, tenantId, n, n2, function1);
    }

    private SolrQuery buildSolrQuery(String query, List<? extends JustApp> apps, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int offset, int count, Function1<? super SolrQuery, Unit> configure) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u245 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)query)) {
            $this$buildSolrQuery_u24lambda_u245.setQuery(query);
        }
        $this$buildSolrQuery_u24lambda_u245.setHighlight(true);
        String[] stringArray = new String[1];
        String string = sortBy.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        stringArray[0] = string + " " + (sortDirection == SortDirection.ASC ? "asc" : "desc");
        $this$buildSolrQuery_u24lambda_u245.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(offset)};
        $this$buildSolrQuery_u24lambda_u245.set("start", stringArray);
        stringArray = new String[]{String.valueOf(count)};
        $this$buildSolrQuery_u24lambda_u245.set("rows", stringArray);
        stringArray = new String[]{REQUESTED_FIELDS};
        $this$buildSolrQuery_u24lambda_u245.set("fl", stringArray);
        stringArray = new String[]{CollectionsKt.joinToString$default((Iterable)apps, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)buildSolrQuery.2.1.INSTANCE), (int)30, null)};
        $this$buildSolrQuery_u24lambda_u245.addFilterQuery(stringArray);
        String searchRoles = CollectionsKt.joinToString$default((Iterable)this.permissionService.getSearchRoles(profileId), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{searchRoles};
        $this$buildSolrQuery_u24lambda_u245.add("justRoles", stringArray2);
        stringArray2 = new String[]{tenantId.toCanonicalId()};
        $this$buildSolrQuery_u24lambda_u245.add("tenantId", stringArray2);
        $this$buildSolrQuery_u24lambda_u245.setRequestHandler("justSearch");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u245);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(SearchService searchService, String string, List list, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int n, int n2, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n3 & 0x100) != 0) {
            function1 = (Function1)buildSolrQuery.1.INSTANCE;
        }
        return searchService.buildSolrQuery(string, list, sortBy, sortDirection, profileId, tenantId, n, n2, function1);
    }

    private SolrQuery buildSolrQueryForNames(int count) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQueryForNames_u24lambda_u246 = solrQuery = new SolrQuery();
        boolean bl = false;
        String[] stringArray = new String[]{REQUESTED_FIELDS_FOR_NAME};
        $this$buildSolrQueryForNames_u24lambda_u246.set("fl", stringArray);
        stringArray = new String[]{String.valueOf(count)};
        $this$buildSolrQueryForNames_u24lambda_u246.set("rows", stringArray);
        return solrQuery;
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            queryResponse = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            Intrinsics.checkNotNull((Object)queryResponse);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u247 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, type, just_app_id, modify_date, name, root_parent_id";
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_FOR_NAME_u24lambda_u248 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl2 = false;
        REQUESTED_FIELDS_FOR_NAME = "id, name";
    }
}

