/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.commentNotifications;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.commentNotifications.CommentNotifications;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Unauthorized;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0017J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsService;", "", "commentNotificationsRepo", "Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "(Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/reaction/ReactionRepo;)V", "getHasNotificationsEnabled", "", "Lde/justsoftware/news/id/PostId;", "", "profileId", "Lde/justsoftware/news/id/ProfileId;", "postIds", "", "setEnabled", "Lde/justsoftware/news/domain/post/Post;", "postId", "enabled", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
@SourceDebugExtension(value={"SMAP\nCommentNotificationsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentNotificationsService.kt\nde/justsoftware/news/domain/commentNotifications/CommentNotificationsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1271#2,2:76\n1285#2,2:78\n1747#2,3:80\n1747#2,3:83\n1747#2,3:86\n1288#2:89\n*S KotlinDebug\n*F\n+ 1 CommentNotificationsService.kt\nde/justsoftware/news/domain/commentNotifications/CommentNotificationsService\n*L\n36#1:76,2\n36#1:78,2\n45#1:80,3\n46#1:83,3\n47#1:86,3\n36#1:89\n*E\n"})
public class CommentNotificationsService {
    @NotNull
    private final CommentNotificationsRepo commentNotificationsRepo;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ReactionRepo reactionRepo;

    public CommentNotificationsService(@NotNull CommentNotificationsRepo commentNotificationsRepo, @NotNull PostCommentRepo postCommentRepo, @NotNull PostRepo postRepo, @NotNull ReactionRepo reactionRepo) {
        Intrinsics.checkNotNullParameter((Object)commentNotificationsRepo, (String)"commentNotificationsRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        this.commentNotificationsRepo = commentNotificationsRepo;
        this.postCommentRepo = postCommentRepo;
        this.postRepo = postRepo;
        this.reactionRepo = reactionRepo;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PostId, Boolean> getHasNotificationsEnabled(@NotNull ProfileId profileId, @NotNull Collection<PostId> postIds) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Map postsToCommentNotifications = this.commentNotificationsRepo.findAllByProfileIdAndPostIdIn(profileId, postIds);
        Set likes = this.reactionRepo.findAllLikesForItemsAndProfile(CollectionsKt.toSet((Iterable)postIds), profileId);
        Set comments = this.postCommentRepo.getAllByAuthorIdAndPostIdIn(profileId, postIds);
        Set authoredPosts = this.postRepo.getAllByAuthorIdAndIdIn(profileId, postIds);
        Iterable $this$associateWith$iv = postIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            boolean bl;
            boolean hasDisabled;
            void postId;
            PostId postId2 = (PostId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl2 = false;
            CommentNotifications commentNotifications = (CommentNotifications)postsToCommentNotifications.get(postId);
            boolean bl3 = hasDisabled = commentNotifications != null && !commentNotifications.getEnabled();
            if (hasDisabled) {
                bl = false;
            } else {
                boolean isAuthor;
                boolean hasCommented;
                boolean hasLiked;
                boolean hasExplicitlyEnabled;
                block14: {
                    boolean bl4;
                    block13: {
                        boolean bl5;
                        block12: {
                            CommentNotifications commentNotifications2 = commentNotifications;
                            hasExplicitlyEnabled = commentNotifications2 != null ? commentNotifications2.getEnabled() : false;
                            Iterable $this$any$iv = likes;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl5 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    Reaction it = (Reaction)element$iv;
                                    boolean bl6 = false;
                                    if (!Intrinsics.areEqual((Object)it.getItemId(), (Object)postId)) continue;
                                    bl5 = true;
                                    break block12;
                                }
                                bl5 = false;
                            }
                        }
                        hasLiked = bl5;
                        Iterable $this$any$iv = comments;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            Object element$iv;
                            element$iv = $this$any$iv.iterator();
                            while (element$iv.hasNext()) {
                                Object element$iv2 = element$iv.next();
                                PostComment it = (PostComment)element$iv2;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)it.getPostId(), (Object)postId)) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    hasCommented = bl4;
                    Iterable $this$any$iv = authoredPosts;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Post it = (Post)element$iv;
                            boolean bl8 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)postId)) continue;
                            v5 = true;
                            break block14;
                        }
                        v5 = isAuthor = false;
                    }
                }
                bl = hasExplicitlyEnabled || hasLiked || hasCommented || isAuthor;
            }
            Boolean bl9 = bl;
            map.put(t, bl9);
        }
        return result$iv;
    }

    @NotNull
    public Post setEnabled(@NotNull PostId postId, boolean enabled, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)postId);
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        this.commentNotificationsRepo.upsert(authContext.getUser(), post.getId(), enabled);
        return post;
    }
}

