/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.drive;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.news.connector.drive.DriveCreateItem;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/news/connector/drive/DriveKafkaProducer;", "", "producer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "", "(Lorg/apache/kafka/clients/producer/KafkaProducer;)V", "deleteAllAttachments", "", "itemId", "Lde/justsoftware/news/id/DriveFileReferenceId;", "publishComment", "comment", "Lde/justsoftware/news/domain/comment/PostComment;", "tenantId", "Lde/justsoftware/news/id/TenantId;", "publishPost", "post", "Lde/justsoftware/news/domain/post/Post;", "news-service"})
public class DriveKafkaProducer {
    @NotNull
    private final KafkaProducer<String, String> producer;

    public DriveKafkaProducer(@NotNull KafkaProducer<String, String> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        this.producer = producer;
    }

    @Async
    public void publishComment(@NotNull PostComment comment, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        String string = comment.getPostId().toTypedString();
        String string2 = comment.getText();
        String string3 = tenantId.toTypedString();
        DriveCreateItem driveItem = new DriveCreateItem(string, string3, string2);
        this.producer.send(new ProducerRecord("just.items", (Object)comment.getId().toTypedString(), (Object)ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).writeValueAsString((Object)driveItem)));
    }

    @Async
    public void publishPost(@NotNull Post post, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DriveCreateItem driveItem = new DriveCreateItem(post.getChannelId().toTypedString(), post.getTitle(), tenantId.toTypedString(), false, 8, null);
        this.producer.send(new ProducerRecord("just.items", (Object)post.getId().toTypedString(), (Object)ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).writeValueAsString((Object)driveItem)));
    }

    @Async
    public void deleteAllAttachments(@NotNull DriveFileReferenceId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.producer.send(new ProducerRecord("just.items", (Object)itemId.toTypedString(), null));
    }
}

