/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.settings.service;

import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.model.UserSettings;
import de.justsoftware.mobile.gateway.toro.model.TranslationLanguage;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;)V", "getPlatformSettings", "Lde/justsoftware/mobile/gateway/settings/model/PlatformSettings;", "getUserSettings", "Lde/justsoftware/mobile/gateway/settings/model/UserSettings;", "mobile-gateway"})
public class SettingsService {
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;

    public SettingsService(@NotNull ToroApiGatewayService toroApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        this.toroApiGatewayService = toroApiGatewayService;
    }

    @NotNull
    public PlatformSettings getPlatformSettings() {
        boolean trackingEnabled = this.toroApiGatewayService.getMobileTrackingEnabled();
        return new PlatformSettings(trackingEnabled);
    }

    @NotNull
    public UserSettings getUserSettings() {
        TranslationLanguage preferredTranslationLanguage = this.toroApiGatewayService.getPreferredTranslationLanguage();
        return new UserSettings(preferredTranslationLanguage);
    }
}

