/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileConfiguration;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UpdateBirthdayData;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.service.PeopleService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/people"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017J6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u0016\u001a\u00020\tH\u0017J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u0016\u001a\u00020\t2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0011H\u0017J$\u0010\u0018\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\u001b\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\r2\b\b\u0001\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010\b\u001a\u00020\tH\u0017J$\u0010 \u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/mobile/gateway/people/controller/PeopleController;", "", "peopleService", "Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "<init>", "(Lde/justsoftware/mobile/gateway/people/service/PeopleService;)V", "getProfile", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "userId", "", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "getAttributes", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "getConfiguration", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileConfiguration;", "updateProfileBirthday", "updateBirthdayData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateBirthdayData;", "mobile-gateway"})
public class PeopleController {
    @NotNull
    private final PeopleService peopleService;

    public PeopleController(@NotNull PeopleService peopleService) {
        Intrinsics.checkNotNullParameter((Object)peopleService, (String)"peopleService");
        this.peopleService = peopleService;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ProfileDetails getProfile(@PathVariable(value="id") @NotNull String userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfile(userId, authContext.getProfileId());
    }

    @GetMapping
    @NotNull
    public List<Profile> getProfiles(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfiles(query, offset, limit);
    }

    @GetMapping(value={"/groups"})
    @NotNull
    public List<UserGroup> getUserGroups(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getUserGroups(query, offset, limit);
    }

    @GetMapping(value={"/groups/{id}"})
    @NotNull
    public UserGroup getUserGroup(@PathVariable(value="id") @NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroup(groupId);
    }

    @GetMapping(value={"/groups/{id}/members"})
    @NotNull
    public List<Profile> getUserGroupMembers(@PathVariable(value="id") @NotNull String groupId, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroupMembers(groupId, offset, limit);
    }

    @PostMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails updateUserImage(@PathVariable(value="id") @NotNull String userId, @RequestPart(value="image") @NotNull MultipartFile image, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateUserImage(userId, image, authContext.getProfileId());
    }

    @DeleteMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails deleteUserImage(@PathVariable(value="id") @NotNull String userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.deleteUserImage(userId, authContext.getProfileId());
    }

    @GetMapping(value={"/{id}/attributes"})
    @NotNull
    public List<ProfileSection> getAttributes(@PathVariable(value="id") @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.peopleService.getAttributes(userId);
    }

    @GetMapping(value={"/{id}/configuration"})
    @NotNull
    public ProfileConfiguration getConfiguration(@PathVariable(value="id") @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.peopleService.getConfiguration(userId);
    }

    @PutMapping(value={"/{id}/birthday"})
    @NotNull
    public ProfileDetails updateProfileBirthday(@PathVariable(value="id") @NotNull String userId, @RequestBody @NotNull UpdateBirthdayData updateBirthdayData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateBirthdayData, (String)"updateBirthdayData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateBirthday(userId, updateBirthdayData, authContext.getProfileId());
    }
}

